/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.apio.internal.architect.provider;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.language.AcceptLanguage;
import com.liferay.apio.architect.provider.Provider;
import com.liferay.portal.apio.user.CurrentUser;
import com.liferay.portal.kernel.model.UserWrapper;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=101"}, service={Provider.class})
public class AcceptLanguageProvider
implements Provider<AcceptLanguage> {
    @Reference
    private Portal _portal;

    public AcceptLanguage createContext(final HttpServletRequest httpServletRequest) {
        return new AcceptLanguage(){

            public Stream<Locale> getLocales() {
                String headerAcceptLanguage = httpServletRequest.getHeader("Accept-Language");
                if (headerAcceptLanguage != null) {
                    Enumeration locales = httpServletRequest.getLocales();
                    ArrayList localesList = Collections.list(locales);
                    return localesList.stream();
                }
                return Stream.empty();
            }

            public Locale getPreferredLocale() {
                Stream<Locale> localeStream = this.getLocales();
                Optional<Locale> localeOptional = localeStream.findFirst();
                return localeOptional.orElseGet(() -> (Locale)Try.fromFallible(() -> Optional.ofNullable(AcceptLanguageProvider.this._portal.getUser(httpServletRequest))).filter(Optional::isPresent).map(Optional::get).map(CurrentUser::new).filter(currentUser -> !currentUser.isDefaultUser()).map(UserWrapper::getLocale).orElse(null));
            }
        };
    }
}

