/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.aop.internal;

import com.liferay.portal.aop.internal.AopServiceRegistrar;
import com.liferay.portal.aop.internal.TransactionHandlerHolder;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AopServiceResolver {
    private final Set<AopServiceRegistrar> _aopServiceRegistrars = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<TransactionHandlerHolder> _transactionHandlerHolders = new CopyOnWriteArrayList<TransactionHandlerHolder>();

    public synchronized void addAopServiceRegistrar(AopServiceRegistrar aopServiceRegistrar) {
        this._aopServiceRegistrars.add(aopServiceRegistrar);
        if (!this._transactionHandlerHolders.isEmpty()) {
            TransactionHandlerHolder topRankingTransactionHandlerHolder = this._transactionHandlerHolders.get(0);
            aopServiceRegistrar.register(topRankingTransactionHandlerHolder.getTransactionHandler());
        }
    }

    public synchronized void addTransactionHandlerHolder(TransactionHandlerHolder transactionHandlerHolder) {
        int index = Collections.binarySearch(this._transactionHandlerHolders, transactionHandlerHolder, Comparator.reverseOrder());
        if (index >= 0) {
            return;
        }
        index = -index - 1;
        this._transactionHandlerHolders.add(index, transactionHandlerHolder);
        if (index > 0) {
            return;
        }
        for (AopServiceRegistrar aopServiceRegistrar : this._aopServiceRegistrars) {
            aopServiceRegistrar.unregister();
        }
        for (AopServiceRegistrar aopServiceRegistrar : this._aopServiceRegistrars) {
            aopServiceRegistrar.register(transactionHandlerHolder.getTransactionHandler());
        }
    }

    public synchronized void removeAopServiceRegistrar(AopServiceRegistrar aopServiceRegistrar) {
        this._aopServiceRegistrars.remove(aopServiceRegistrar);
    }

    public synchronized void removeTransactionHandlerHolder(TransactionHandlerHolder transactionHandlerHolder) {
        int index = this._transactionHandlerHolders.indexOf(transactionHandlerHolder);
        if (index < 0) {
            return;
        }
        this._transactionHandlerHolders.remove(index);
        if (index > 0) {
            return;
        }
        for (AopServiceRegistrar aopServiceRegistrar : this._aopServiceRegistrars) {
            aopServiceRegistrar.unregister();
        }
        if (this._transactionHandlerHolders.isEmpty()) {
            return;
        }
        TransactionHandlerHolder topRankingTransactionHandlerHolder = this._transactionHandlerHolders.get(0);
        for (AopServiceRegistrar aopServiceRegistrar : this._aopServiceRegistrars) {
            aopServiceRegistrar.register(topRankingTransactionHandlerHolder.getTransactionHandler());
        }
    }
}

