/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.aop.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.module.util.BundleUtil;
import com.liferay.portal.spring.aop.AopCacheManager;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import com.liferay.portal.spring.transaction.TransactionHandler;
import java.lang.reflect.InvocationHandler;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class AopServiceRegistrar {
    private static final Set<String> _frameworkKeys = new HashSet<String>(Arrays.asList("component.id", "component.name", "objectClass", "service.bundleid", "service.id", "service.scope"));
    private AopInvocationHandler _aopInvocationHandler;
    private final AopService _aopService;
    private final Class<?>[] _aopServiceInterfaces;
    private final boolean _liferayService;
    private final ServiceReference<AopService> _serviceReference;
    private ServiceRegistration<?> _serviceRegistration;

    public AopServiceRegistrar(ServiceReference<AopService> serviceReference, AopService aopService, Class<?>[] aopServiceInterfaces) {
        this._serviceReference = serviceReference;
        this._aopService = aopService;
        this._aopServiceInterfaces = aopServiceInterfaces;
        this._liferayService = BundleUtil.isLiferayServiceBundle((Bundle)serviceReference.getBundle());
    }

    public boolean isLiferayService() {
        return this._liferayService;
    }

    public void register(TransactionHandler transactionHandler) {
        Bundle bundle = this._serviceReference.getBundle();
        BundleContext bundleContext = bundle.getBundleContext();
        String[] aopServiceNames = new String[this._aopServiceInterfaces.length];
        for (int i = 0; i < this._aopServiceInterfaces.length; ++i) {
            aopServiceNames[i] = this._aopServiceInterfaces[i].getName();
        }
        this._serviceRegistration = bundleContext.registerService(aopServiceNames, this._getService(bundleContext, transactionHandler), this._getProperties(this._serviceReference));
    }

    public void unregister() {
        if (this._serviceRegistration != null) {
            if (this._aopInvocationHandler != null) {
                AopCacheManager.destroy((AopInvocationHandler)this._aopInvocationHandler);
                this._aopInvocationHandler = null;
            }
            this._serviceRegistration.unregister();
            this._serviceRegistration = null;
        }
    }

    public void updateProperties() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.setProperties(this._getProperties(this._serviceReference));
        }
    }

    private Dictionary<String, Object> _getProperties(ServiceReference<AopService> serviceReference) {
        HashMapDictionary properties = null;
        for (String key : serviceReference.getPropertyKeys()) {
            if (_frameworkKeys.contains(key)) continue;
            if (properties == null) {
                properties = new HashMapDictionary();
            }
            properties.put(key, serviceReference.getProperty(key));
        }
        return properties;
    }

    private Object _getService(BundleContext bundleContext, TransactionHandler transactionHandler) {
        Object serviceScope = this._serviceReference.getProperty("service.scope");
        if ("prototype".equals(serviceScope)) {
            return new AopServicePrototypeServiceFactory(bundleContext.getServiceObjects(this._serviceReference), transactionHandler);
        }
        this._aopInvocationHandler = AopCacheManager.create((Object)this._aopService, (TransactionHandler)transactionHandler);
        Class<?> aopServiceClass = this._aopService.getClass();
        Object aopProxy = ProxyUtil.newProxyInstance((ClassLoader)aopServiceClass.getClassLoader(), (Class[])this._aopServiceInterfaces, (InvocationHandler)this._aopInvocationHandler);
        this._aopService.setAopProxy(aopProxy);
        return aopProxy;
    }

    private class AopServicePrototypeServiceFactory
    implements PrototypeServiceFactory<Object> {
        private final Map<AopInvocationHandler, AopService> _aopServices = new ConcurrentHashMap<AopInvocationHandler, AopService>();
        private final ServiceObjects<AopService> _serviceObjects;
        private final TransactionHandler _transactionHandler;

        public Object getService(Bundle bundle, ServiceRegistration<Object> serviceRegistration) {
            AopService aopService = (AopService)this._serviceObjects.getService();
            Object[] aopInterfaces = aopService.getAopInterfaces();
            Class<?> aopServiceClass = aopService.getClass();
            if (ArrayUtil.isEmpty((Object[])aopInterfaces)) {
                aopInterfaces = (Class[])ArrayUtil.remove((Object[])aopServiceClass.getInterfaces(), AopService.class);
            }
            if (!Arrays.equals(AopServiceRegistrar.this._aopServiceInterfaces, aopInterfaces)) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Prototype AopService ", aopService, " must have immutable AOP interfaces, expected ", Arrays.toString(AopServiceRegistrar.this._aopServiceInterfaces), " but was ", Arrays.toString(aopInterfaces)}));
            }
            AopInvocationHandler aopInvocationHandler = AopCacheManager.create((Object)aopService, (TransactionHandler)this._transactionHandler);
            this._aopServices.put(aopInvocationHandler, aopService);
            Object aopProxy = ProxyUtil.newProxyInstance((ClassLoader)aopServiceClass.getClassLoader(), (Class[])AopServiceRegistrar.this._aopServiceInterfaces, (InvocationHandler)aopInvocationHandler);
            aopService.setAopProxy(aopProxy);
            return aopProxy;
        }

        public void ungetService(Bundle bundle, ServiceRegistration<Object> serviceRegistration, Object aopProxy) {
            AopInvocationHandler aopInvocationHandler = (AopInvocationHandler)ProxyUtil.fetchInvocationHandler((Object)aopProxy, AopInvocationHandler.class);
            AopCacheManager.destroy((AopInvocationHandler)aopInvocationHandler);
            this._serviceObjects.ungetService((Object)this._aopServices.remove(aopInvocationHandler));
        }

        private AopServicePrototypeServiceFactory(ServiceObjects<AopService> serviceObjects, TransactionHandler transactionHandler) {
            this._serviceObjects = serviceObjects;
            this._transactionHandler = transactionHandler;
        }
    }
}

