/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.aop.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.aop.internal.AopServiceRegistrar;
import com.liferay.portal.aop.internal.AopServiceResolver;
import com.liferay.portal.aop.internal.TransactionHandlerHolder;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.spring.transaction.TransactionHandler;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={})
public class AopServiceManager {
    private final Map<Object, AopServiceResolver> _aopDependencyResolvers = new ConcurrentHashMap<Object, AopServiceResolver>();
    private ServiceTracker<AopService, AopServiceRegistrar> _aopServiceServiceTracker;
    private BundleContext _bundleContext;
    @Reference(target="(&(bean.id=transactionExecutor)(original.bean=true))")
    private TransactionHandler _portalTransactionHandler;
    private SynchronousBundleListener _synchronousBundleListener;
    private ServiceTracker<TransactionHandler, TransactionHandlerHolder> _transactionHandlerServiceTracker;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._synchronousBundleListener = bundleEvent -> {
            if (bundleEvent.getType() == 256) {
                Bundle bundle = bundleEvent.getBundle();
                this._aopDependencyResolvers.remove(bundle.getBundleId());
            }
        };
        this._bundleContext.addBundleListener((BundleListener)this._synchronousBundleListener);
        this._aopServiceServiceTracker = new ServiceTracker(bundleContext, AopService.class, (ServiceTrackerCustomizer)new AopServiceServiceTrackerCustomizer());
        this._aopServiceServiceTracker.open();
        this._transactionHandlerServiceTracker = new ServiceTracker(bundleContext, TransactionHandler.class, (ServiceTrackerCustomizer)new TransactionHandlerServiceTrackerCustomizer());
        this._transactionHandlerServiceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._aopServiceServiceTracker.close();
        this._transactionHandlerServiceTracker.close();
        this._bundleContext.removeBundleListener((BundleListener)this._synchronousBundleListener);
        this._aopDependencyResolvers.clear();
    }

    private class TransactionHandlerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<TransactionHandler, TransactionHandlerHolder> {
        private TransactionHandlerServiceTrackerCustomizer() {
        }

        public TransactionHandlerHolder addingService(ServiceReference<TransactionHandler> serviceReference) {
            TransactionHandler transactionHandler = (TransactionHandler)AopServiceManager.this._bundleContext.getService(serviceReference);
            TransactionHandlerHolder transactionHandlerHolder = new TransactionHandlerHolder(serviceReference, transactionHandler);
            AopServiceResolver aopServiceResolver = AopServiceManager.this._aopDependencyResolvers.computeIfAbsent(serviceReference.getProperty("service.bundleid"), bundleId -> new AopServiceResolver());
            aopServiceResolver.addTransactionHandlerHolder(transactionHandlerHolder);
            return transactionHandlerHolder;
        }

        public void modifiedService(ServiceReference<TransactionHandler> serviceReference, TransactionHandlerHolder transactionHandlerHolder) {
        }

        public void removedService(ServiceReference<TransactionHandler> serviceReference, TransactionHandlerHolder transactionHandlerHolder) {
            AopServiceResolver aopServiceResolver = (AopServiceResolver)AopServiceManager.this._aopDependencyResolvers.get(serviceReference.getProperty("service.bundleid"));
            if (aopServiceResolver != null) {
                aopServiceResolver.removeTransactionHandlerHolder(transactionHandlerHolder);
            }
            AopServiceManager.this._bundleContext.ungetService(serviceReference);
        }
    }

    private class AopServiceServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<AopService, AopServiceRegistrar> {
        private AopServiceServiceTrackerCustomizer() {
        }

        public AopServiceRegistrar addingService(ServiceReference<AopService> serviceReference) {
            AopService aopService = (AopService)AopServiceManager.this._bundleContext.getService(serviceReference);
            Class<?>[] aopInterfaces = this._getAopInterfaces(aopService);
            if (aopInterfaces.length == 0) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Unable to register ", aopService.getClass(), " without a service interface"}));
            }
            AopServiceRegistrar aopServiceRegistrar = new AopServiceRegistrar(serviceReference, aopService, aopInterfaces);
            if (aopServiceRegistrar.isLiferayService()) {
                AopServiceResolver aopServiceResolver = AopServiceManager.this._aopDependencyResolvers.computeIfAbsent(serviceReference.getProperty("service.bundleid"), bundleId -> new AopServiceResolver());
                aopServiceResolver.addAopServiceRegistrar(aopServiceRegistrar);
            } else {
                aopServiceRegistrar.register(AopServiceManager.this._portalTransactionHandler);
            }
            return aopServiceRegistrar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modifiedService(ServiceReference<AopService> serviceReference, AopServiceRegistrar aopServiceRegistrar) {
            if (aopServiceRegistrar.isLiferayService()) {
                AopServiceResolver aopServiceResolver;
                AopServiceResolver aopServiceResolver2 = aopServiceResolver = (AopServiceResolver)AopServiceManager.this._aopDependencyResolvers.get(serviceReference.getProperty("service.bundleid"));
                synchronized (aopServiceResolver2) {
                    aopServiceRegistrar.updateProperties();
                }
            } else {
                aopServiceRegistrar.updateProperties();
            }
        }

        public void removedService(ServiceReference<AopService> serviceReference, AopServiceRegistrar aopServiceRegistrar) {
            AopServiceResolver aopServiceResolver;
            if (aopServiceRegistrar.isLiferayService() && (aopServiceResolver = (AopServiceResolver)AopServiceManager.this._aopDependencyResolvers.get(serviceReference.getProperty("service.bundleid"))) != null) {
                aopServiceResolver.removeAopServiceRegistrar(aopServiceRegistrar);
            }
            aopServiceRegistrar.unregister();
            AopServiceManager.this._bundleContext.ungetService(serviceReference);
        }

        private Class<?>[] _getAopInterfaces(AopService aopService) {
            Object[] aopInterfaces = aopService.getAopInterfaces();
            Class<?> aopServiceClass = aopService.getClass();
            if (ArrayUtil.isEmpty((Object[])aopInterfaces)) {
                return (Class[])ArrayUtil.remove((Object[])aopServiceClass.getInterfaces(), AopService.class);
            }
            for (Object aopInterface : aopInterfaces) {
                if (!((Class)aopInterface).isInterface()) {
                    throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Unable to proxy ", aopServiceClass, " because ", aopInterface, " is not an interface"}));
                }
                if (!((Class)aopInterface).isAssignableFrom(aopServiceClass)) {
                    throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Unable to proxy ", aopServiceClass, " because ", aopInterface, " is not implemented"}));
                }
                if (aopInterface != AopService.class) continue;
                throw new IllegalArgumentException("Do not include AopService in service interfaces");
            }
            return (Class[])Arrays.copyOf(aopInterfaces, aopInterfaces.length);
        }
    }
}

