/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.pmd.rules.junit;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.rule.junit.AbstractJUnitRule;

public class AssertFailJUnitRule
extends AbstractJUnitRule {
    public Object visit(ASTClassOrInterfaceDeclaration astClassOrInterfaceDeclaration, Object data) {
        if (astClassOrInterfaceDeclaration.isInterface()) {
            return data;
        }
        return super.visit(astClassOrInterfaceDeclaration, data);
    }

    public Object visit(ASTStatementExpression astStatementExpression, Object data) {
        if (!this.isAssertFailStatement(astStatementExpression)) {
            return data;
        }
        ASTTryStatement astTryStatement = (ASTTryStatement)astStatementExpression.getFirstParentOfType(ASTTryStatement.class);
        if (astTryStatement == null) {
            this.addViolation(data, (Node)astStatementExpression);
            return data;
        }
        ASTCatchStatement astCatchStatement = (ASTCatchStatement)astStatementExpression.getFirstParentOfType(ASTCatchStatement.class);
        if (astCatchStatement != null) {
            this.addViolation(data, (Node)astStatementExpression);
            return data;
        }
        ASTBlock astBlock = (ASTBlock)astTryStatement.getFirstChildOfType(ASTBlock.class);
        List astStatementExpressions = astBlock.findDescendantsOfType(ASTStatementExpression.class);
        ASTStatementExpression lastASTStatementExpression = (ASTStatementExpression)astStatementExpressions.get(astStatementExpressions.size() - 1);
        if (!lastASTStatementExpression.equals(astStatementExpression)) {
            this.addViolation(data, (Node)astStatementExpression);
            return data;
        }
        return data;
    }

    private boolean isAssertFailStatement(ASTStatementExpression astStatementExpression) {
        if (astStatementExpression == null || astStatementExpression.jjtGetNumChildren() == 0) {
            return false;
        }
        Node node = astStatementExpression.jjtGetChild(0);
        if (!(node instanceof ASTPrimaryExpression)) {
            return false;
        }
        ASTPrimaryExpression astPrimaryExpression = (ASTPrimaryExpression)node;
        if (astPrimaryExpression.jjtGetNumChildren() == 0) {
            return false;
        }
        node = astPrimaryExpression.jjtGetChild(0);
        if (!(node instanceof ASTPrimaryPrefix)) {
            return false;
        }
        ASTPrimaryPrefix astPrimaryPrefix = (ASTPrimaryPrefix)node;
        if (astPrimaryPrefix.jjtGetNumChildren() == 0) {
            return false;
        }
        node = astPrimaryPrefix.jjtGetChild(0);
        if (!(node instanceof ASTName)) {
            return false;
        }
        ASTName astName = (ASTName)node;
        String image = astName.getImage();
        return image != null && (image.equals("fail") || image.equals("Assert.fail"));
    }
}

