/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.plugins.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.PluginSettingService;
import com.liferay.portal.kernel.service.PortletService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_plugins_admin_web_portlet_PluginsAdminPortlet", "mvc.command.name=/plugins_admin/edit_plugin"}, service={MVCActionCommand.class})
public class EditPluginActionCommand
extends BaseMVCActionCommand {
    private PluginSettingService _pluginSettingService;
    @Reference
    private Portal _portal;
    private PortletService _portletService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.updatePluginSetting(actionRequest);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.sendRedirect(actionRequest, actionResponse, "/error.jsp");
            }
            throw e;
        }
    }

    @Reference(unbind="-")
    protected void setPluginSettingService(PluginSettingService pluginSettingService) {
        this._pluginSettingService = pluginSettingService;
    }

    @Reference(unbind="-")
    protected void setPortletService(PortletService portletService) {
        this._portletService = portletService;
    }

    protected void updatePluginSetting(ActionRequest actionRequest) throws Exception {
        long companyId = this._portal.getCompanyId((PortletRequest)actionRequest);
        String pluginId = ParamUtil.getString((PortletRequest)actionRequest, (String)"pluginId");
        String pluginType = ParamUtil.getString((PortletRequest)actionRequest, (String)"pluginType");
        Object[] rolesArray = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"roles"), (char)'\n');
        Arrays.sort(rolesArray);
        String roles = StringUtil.merge((Object[])rolesArray);
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        if (pluginType.equals("portlet")) {
            String portletId = pluginId;
            this._portletService.updatePortlet(companyId, portletId, "", active);
        } else {
            this._pluginSettingService.updatePluginSetting(companyId, pluginId, pluginType, roles, active);
        }
    }
}

