/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.url.pattern.mapper.internal;

import com.liferay.petra.url.pattern.mapper.internal.BaseTrieURLPatternMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class StaticSizeTrieURLPatternMapper<T>
extends BaseTrieURLPatternMapper<T> {
    private static final long _BITMASK = -1L;
    private static final int _INDEX_SLASH = 15;
    private static final int _INDEX_STAR = 10;
    private final long[][][] _extensionTrieMatrix;
    private int _extensionURLPatternsCount;
    private final List<T> _extensionValues = new ArrayList<T>(64);
    private final int _maxURLPatternLength;
    private final long[][][] _wildCardTrieMatrix;
    private int _wildcardURLPatternCount;
    private final List<T> _wildcardValues = new ArrayList<T>(64);

    public StaticSizeTrieURLPatternMapper(Map<String, T> values) {
        int maxURLPatternLength = 0;
        for (Map.Entry<String, T> entry : values.entrySet()) {
            String urlPattern = entry.getKey();
            if (Objects.isNull(urlPattern) || urlPattern.length() == 0) {
                throw new IllegalArgumentException("URL pattern is blank");
            }
            if (urlPattern.length() <= maxURLPatternLength) continue;
            maxURLPatternLength = urlPattern.length();
        }
        this._maxURLPatternLength = maxURLPatternLength + 2;
        this._extensionTrieMatrix = new long[2][this._maxURLPatternLength][96];
        this._wildCardTrieMatrix = new long[2][this._maxURLPatternLength][96];
        for (Map.Entry<String, T> entry : values.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected void consumeWildcardValues(Consumer<T> consumer, String urlPath) {
        for (long valuesBitmask = this._getWildcardValuesBitmask(urlPath); valuesBitmask != 0L; valuesBitmask &= valuesBitmask - 1L) {
            consumer.accept(this._wildcardValues.get(this._getFirstSetBitIndex(valuesBitmask)));
        }
    }

    @Override
    protected T getExtensionValue(String urlPath) {
        int column;
        char character;
        long currentBitmask = -1L;
        int maxRow = Math.min(urlPath.length(), this._maxURLPatternLength - 1);
        for (int row = 0; row < maxRow && (character = urlPath.charAt(urlPath.length() - 1 - row)) != '/' && (currentBitmask &= this._extensionTrieMatrix[0][row][column = character - 32]) != 0L; ++row) {
            if (character != '.') continue;
            return this._extensionValues.get(this._getFirstSetBitIndex(currentBitmask));
        }
        return null;
    }

    @Override
    protected T getWildcardValue(String urlPath) {
        long bitmask;
        char character;
        int row;
        boolean exact = false;
        boolean wildcard = false;
        if (urlPath.charAt(0) != '/') {
            exact = true;
        } else if (urlPath.length() > 1 && urlPath.charAt(urlPath.length() - 2) == '/' && urlPath.charAt(urlPath.length() - 1) == '*') {
            wildcard = true;
        }
        long bestMatchBitmask = 0L;
        int column = 0;
        long currentBitmask = -1L;
        int maxRow = Math.min(urlPath.length(), this._maxURLPatternLength - 1);
        for (row = 0; row < maxRow && (currentBitmask &= this._wildCardTrieMatrix[0][row][column = (character = urlPath.charAt(row)) - 32]) != 0L; ++row) {
            long bitmask2;
            if (exact || character != '/' || (bitmask2 = currentBitmask & this._wildCardTrieMatrix[1][row + 1][10]) == 0L) continue;
            bestMatchBitmask = bitmask2;
        }
        if (currentBitmask == 0L) {
            if (bestMatchBitmask == 0L) {
                return null;
            }
            return this._wildcardValues.get(this._getFirstSetBitIndex(bestMatchBitmask));
        }
        if (exact) {
            long bitmask3 = currentBitmask & this._wildCardTrieMatrix[1][row - 1][column];
            if (bitmask3 != 0L) {
                return this._wildcardValues.get(this._getFirstSetBitIndex(bitmask3));
            }
            return null;
        }
        if (!wildcard && (bitmask = currentBitmask & this._wildCardTrieMatrix[1][row - 1][column]) != 0L) {
            return this._wildcardValues.get(this._getFirstSetBitIndex(bitmask));
        }
        long extraBitmask = currentBitmask & this._wildCardTrieMatrix[0][row][15];
        extraBitmask &= this._wildCardTrieMatrix[0][row + 1][10];
        if ((extraBitmask &= this._wildCardTrieMatrix[1][row + 1][10]) != 0L) {
            return this._wildcardValues.get(this._getFirstSetBitIndex(extraBitmask));
        }
        return this._wildcardValues.get(this._getFirstSetBitIndex(bestMatchBitmask));
    }

    @Override
    protected void put(String urlPattern, T value, boolean wildcard) {
        int row;
        List<T> values = null;
        long[][][] trieMatrix = null;
        if (wildcard) {
            values = this._wildcardValues;
            trieMatrix = this._wildCardTrieMatrix;
        } else {
            values = this._extensionValues;
            trieMatrix = this._extensionTrieMatrix;
        }
        if (!wildcard && this._extensionURLPatternsCount > 63 || wildcard && this._wildcardURLPatternCount > 63) {
            throw new IllegalArgumentException("Exceeding maximum number of allowed URL patterns");
        }
        int index = 0;
        index = wildcard ? this._wildcardURLPatternCount++ : this._extensionURLPatternsCount++;
        long bitmask = 1L << index;
        int column = 0;
        for (row = 0; row < urlPattern.length(); ++row) {
            char character = wildcard ? urlPattern.charAt(row) : urlPattern.charAt(urlPattern.length() - 1 - row);
            column = character - 32;
            long[] lArray = trieMatrix[0][row];
            int n = column;
            lArray[n] = lArray[n] | bitmask;
        }
        long[] lArray = trieMatrix[1][row - 1];
        int n = column;
        lArray[n] = lArray[n] | bitmask;
        values.add(value);
    }

    private int _getFirstSetBitIndex(long bitmask) {
        int firstSetBitIndex = 63;
        long currentBitmask = bitmask << 32;
        if (currentBitmask != 0L) {
            bitmask = currentBitmask;
            firstSetBitIndex -= 32;
        }
        if ((currentBitmask = bitmask << 16) != 0L) {
            bitmask = currentBitmask;
            firstSetBitIndex -= 16;
        }
        if ((currentBitmask = bitmask << 8) != 0L) {
            bitmask = currentBitmask;
            firstSetBitIndex -= 8;
        }
        if ((currentBitmask = bitmask << 4) != 0L) {
            bitmask = currentBitmask;
            firstSetBitIndex -= 4;
        }
        if ((currentBitmask = bitmask << 2) != 0L) {
            bitmask = currentBitmask;
            firstSetBitIndex -= 2;
        }
        if ((currentBitmask = bitmask << 1) != 0L) {
            --firstSetBitIndex;
        }
        return firstSetBitIndex;
    }

    private long _getWildcardValuesBitmask(String urlPath) {
        long bitmask;
        char character;
        int row;
        long valuesBitmask = 0L;
        boolean exact = false;
        boolean wildcard = false;
        if (urlPath.charAt(0) != '/') {
            exact = true;
        } else if (urlPath.length() > 1 && urlPath.charAt(urlPath.length() - 2) == '/' && urlPath.charAt(urlPath.length() - 1) == '*') {
            wildcard = true;
        }
        int column = 0;
        long currentBitmask = -1L;
        int maxRow = Math.min(urlPath.length(), this._maxURLPatternLength - 1);
        for (row = 0; row < maxRow && (currentBitmask &= this._wildCardTrieMatrix[0][row][column = (character = urlPath.charAt(row)) - 32]) != 0L; ++row) {
            long bitmask2;
            if (exact || character != '/' || (bitmask2 = currentBitmask & this._wildCardTrieMatrix[1][row + 1][10]) == 0L) continue;
            valuesBitmask |= bitmask2;
        }
        if (currentBitmask == 0L) {
            return valuesBitmask;
        }
        if (exact) {
            long bitmask3 = currentBitmask & this._wildCardTrieMatrix[1][row - 1][column];
            if (bitmask3 != 0L) {
                valuesBitmask |= bitmask3;
            }
            return valuesBitmask;
        }
        if (!wildcard && (bitmask = currentBitmask & this._wildCardTrieMatrix[1][row - 1][column]) != 0L) {
            valuesBitmask |= bitmask;
        }
        long extraBitmask = currentBitmask & this._wildCardTrieMatrix[0][row][15];
        extraBitmask &= this._wildCardTrieMatrix[0][row + 1][10];
        if ((extraBitmask &= this._wildCardTrieMatrix[1][row + 1][10]) != 0L) {
            valuesBitmask |= extraBitmask;
        }
        return valuesBitmask;
    }
}

