/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.string;

import com.liferay.petra.string.StringPool;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;

public class StringBundler
implements Serializable {
    private static final int _DEFAULT_ARRAY_CAPACITY = 10;
    private static final long serialVersionUID = 1L;
    private String[] _array;
    private int _arrayIndex;

    public static String concat(Object ... objects) {
        String[] strings = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            strings[i] = String.valueOf(objects[i]);
        }
        return StringBundler._toString(strings, strings.length);
    }

    public static String concat(String ... strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] != null) continue;
            strings[i] = "null";
        }
        return StringBundler._toString(strings, strings.length);
    }

    public StringBundler() {
        this._array = StringPool.EMPTY_ARRAY;
    }

    public StringBundler(int initialCapacity) {
        this._array = initialCapacity <= 0 ? StringPool.EMPTY_ARRAY : new String[initialCapacity];
    }

    public StringBundler(String s) {
        this._array = new String[10];
        this._array[0] = s;
        this._arrayIndex = 1;
    }

    public StringBundler(String[] stringArray) {
        this(stringArray, 0);
    }

    public StringBundler(String[] stringArray, int extraSpace) {
        this._array = new String[stringArray.length + extraSpace];
        for (String s : stringArray) {
            if (s == null || s.isEmpty()) continue;
            this._array[this._arrayIndex++] = s;
        }
    }

    public StringBundler append(boolean b) {
        if (b) {
            return this.append("true");
        }
        return this.append("false");
    }

    public StringBundler append(char c) {
        return this.append(String.valueOf(c));
    }

    public StringBundler append(char[] chars) {
        if (chars == null) {
            return this.append("null");
        }
        return this.append(new String(chars));
    }

    public StringBundler append(double d) {
        return this.append(String.valueOf(d));
    }

    public StringBundler append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringBundler append(int i) {
        return this.append(String.valueOf(i));
    }

    public StringBundler append(long l) {
        return this.append(String.valueOf(l));
    }

    public StringBundler append(Object object) {
        return this.append(String.valueOf(object));
    }

    public StringBundler append(String s) {
        if (s == null) {
            s = "null";
        }
        if (s.isEmpty()) {
            return this;
        }
        if (this._arrayIndex >= this._array.length) {
            this.expandCapacity(this._array.length * 2);
        }
        this._array[this._arrayIndex++] = s;
        return this;
    }

    public StringBundler append(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this;
        }
        if (this._array.length - this._arrayIndex < stringArray.length) {
            this.expandCapacity((this._array.length + stringArray.length) * 2);
        }
        for (String s : stringArray) {
            if (s == null || s.length() <= 0) continue;
            this._array[this._arrayIndex++] = s;
        }
        return this;
    }

    public StringBundler append(StringBundler sb) {
        if (sb == null || sb._arrayIndex == 0) {
            return this;
        }
        if (this._array.length - this._arrayIndex < sb._arrayIndex) {
            this.expandCapacity((this._array.length + sb._arrayIndex) * 2);
        }
        System.arraycopy(sb._array, 0, this._array, this._arrayIndex, sb._arrayIndex);
        this._arrayIndex += sb._arrayIndex;
        return this;
    }

    public int capacity() {
        return this._array.length;
    }

    public String[] getStrings() {
        return this._array;
    }

    public int index() {
        return this._arrayIndex;
    }

    public int length() {
        int length = 0;
        for (int i = 0; i < this._arrayIndex; ++i) {
            length += this._array[i].length();
        }
        return length;
    }

    public void setIndex(int newIndex) {
        if (newIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(newIndex);
        }
        if (newIndex > this._array.length) {
            String[] newArray = new String[newIndex];
            System.arraycopy(this._array, 0, newArray, 0, this._arrayIndex);
            this._array = newArray;
        }
        if (this._arrayIndex < newIndex) {
            for (int i = this._arrayIndex; i < newIndex; ++i) {
                this._array[i] = "";
            }
        }
        if (this._arrayIndex > newIndex) {
            for (int i = newIndex; i < this._arrayIndex; ++i) {
                this._array[i] = null;
            }
        }
        this._arrayIndex = newIndex;
    }

    public void setStringAt(String s, int index) {
        if (index < 0 || index >= this._arrayIndex) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this._array[index] = s;
    }

    public String stringAt(int index) {
        if (index < 0 || index >= this._arrayIndex) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this._array[index];
    }

    public String toString() {
        return StringBundler._toString(this._array, this._arrayIndex);
    }

    public void writeTo(Writer writer) throws IOException {
        for (int i = 0; i < this._arrayIndex; ++i) {
            writer.write(this._array[i]);
        }
    }

    protected void expandCapacity(int newCapacity) {
        if (newCapacity == 0) {
            newCapacity = 10;
        }
        String[] newArray = new String[newCapacity];
        System.arraycopy(this._array, 0, newArray, 0, this._arrayIndex);
        this._array = newArray;
    }

    private static String _toString(String[] array, int arrayIndex) {
        if (arrayIndex == 0) {
            return "";
        }
        if (arrayIndex == 1) {
            return array[0];
        }
        if (arrayIndex == 2) {
            return array[0].concat(array[1]);
        }
        String result = StringBundler._toStringStringConcatenator(array, arrayIndex);
        if (result == null) {
            return StringBundler._toStringSB(array, arrayIndex);
        }
        return result;
    }

    private static String _toStringSB(String[] array, int arrayIndex) {
        int length = 0;
        for (int i = 0; i < arrayIndex; ++i) {
            length += array[i].length();
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < arrayIndex; ++i) {
            sb.append(array[i]);
        }
        return sb.toString();
    }

    private static String _toStringStringConcatenator(String[] array, int arrayIndex) {
        if (StringConcatenator._stringConcatenator == null) {
            return null;
        }
        return StringConcatenator._stringConcatenator.concat(array, arrayIndex);
    }

    private static abstract class StringConcatenator {
        private static final StringConcatenator _stringConcatenator;

        private StringConcatenator() {
        }

        public abstract String concat(String[] var1, int var2);

        static {
            StringConcatenator stringConcatenator = null;
            try {
                Field field = String.class.getDeclaredField("value");
                Class<?> valueType = field.getType();
                if (valueType == char[].class) {
                    stringConcatenator = new CharArrayStringConcatenator();
                } else if (valueType == byte[].class) {
                    stringConcatenator = new ByteArrayStringConcatenator();
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            _stringConcatenator = stringConcatenator;
        }
    }

    private static class CharArrayStringConcatenator
    extends StringConcatenator {
        private static final MethodHandle _constructorMethodHandle;
        private static final MethodHandle _valueMethodHandle;

        private CharArrayStringConcatenator() {
        }

        @Override
        public String concat(String[] array, int arrayIndex) {
            try {
                int length = 0;
                for (int i = 0; i < arrayIndex; ++i) {
                    length += array[i].length();
                }
                char[] chars = new char[length];
                int index = 0;
                for (int i = 0; i < arrayIndex; ++i) {
                    char[] value = _valueMethodHandle.invokeExact(array[i]);
                    System.arraycopy(value, 0, chars, index, value.length);
                    index += value.length;
                }
                return _constructorMethodHandle.invokeExact(chars, true);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        static {
            try {
                Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                field.setAccessible(true);
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)field.get(null);
                _constructorMethodHandle = lookup.unreflectConstructor(String.class.getDeclaredConstructor(char[].class, Boolean.TYPE));
                _valueMethodHandle = lookup.findGetter(String.class, "value", char[].class);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new ExceptionInInitializerError(reflectiveOperationException);
            }
        }
    }

    private static class ByteArrayStringConcatenator
    extends StringConcatenator {
        private static final MethodHandle _coderMethodHandle;
        private static final MethodHandle _constructorMethodHandle;
        private static final MethodHandle _valueMethodHandle;

        private ByteArrayStringConcatenator() {
        }

        @Override
        public String concat(String[] array, int arrayIndex) {
            try {
                byte coder = _coderMethodHandle.invokeExact(array[0]);
                int length = 0;
                for (int i = 0; i < arrayIndex; ++i) {
                    if (coder != _coderMethodHandle.invokeExact(array[i])) {
                        return null;
                    }
                    length += array[i].length();
                }
                byte[] bytes = new byte[length <<= coder];
                int index = 0;
                for (int i = 0; i < arrayIndex; ++i) {
                    byte[] value = _valueMethodHandle.invokeExact(array[i]);
                    System.arraycopy(value, 0, bytes, index, value.length);
                    index += value.length;
                }
                return _constructorMethodHandle.invokeExact(bytes, coder);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        static {
            try {
                Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                field.setAccessible(true);
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)field.get(null);
                _coderMethodHandle = lookup.findGetter(String.class, "coder", Byte.TYPE);
                _constructorMethodHandle = lookup.unreflectConstructor(String.class.getDeclaredConstructor(byte[].class, Byte.TYPE));
                _valueMethodHandle = lookup.findGetter(String.class, "value", byte[].class);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new ExceptionInInitializerError(reflectiveOperationException);
            }
        }
    }
}

