/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.sql.dsl.spi.query;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNode;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.spi.ast.BaseASTNode;
import com.liferay.petra.sql.dsl.spi.query.DefaultJoinStep;
import com.liferay.petra.sql.dsl.spi.query.JoinType;
import java.util.Objects;
import java.util.function.Consumer;

public class Join
extends BaseASTNode
implements DefaultJoinStep {
    private final JoinType _joinType;
    private final Predicate _onPredicate;
    private final Table<?> _table;

    public Join(JoinStep joinStep, JoinType joinType, Table<?> table, Predicate onPredicate) {
        super((ASTNode)joinStep);
        this._joinType = Objects.requireNonNull(joinType);
        this._table = Objects.requireNonNull(table);
        this._onPredicate = Objects.requireNonNull(onPredicate);
    }

    public JoinType getJoinType() {
        return this._joinType;
    }

    public Predicate getOnPredicate() {
        return this._onPredicate;
    }

    public Table<?> getTable() {
        return this._table;
    }

    @Override
    protected void doToSQL(Consumer<String> consumer, ASTNodeListener astNodeListener) {
        consumer.accept(this._joinType.getStringWithJoin());
        this._table.toSQL(consumer, astNodeListener);
        consumer.accept(" on ");
        this._onPredicate.toSQL(consumer, astNodeListener);
    }
}

