/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.sql.dsl.spi.expression;

import com.liferay.petra.sql.dsl.ast.ASTNode;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.spi.ast.BaseASTNode;
import com.liferay.petra.sql.dsl.spi.expression.DefaultExpression;
import com.liferay.petra.sql.dsl.spi.expression.Operand;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;

public class DefaultPredicate
extends BaseASTNode
implements DefaultExpression<Boolean>,
Predicate {
    private final Expression<?> _leftExpression;
    private final Operand _operand;
    private final Expression<?> _rightExpression;
    private final boolean _wrapParentheses;

    public DefaultPredicate(Expression<?> leftExpression, Operand operand, Expression<?> rightExpression) {
        this(leftExpression, operand, rightExpression, false);
    }

    public Predicate and(Expression<Boolean> expression) {
        if (expression == null) {
            return this;
        }
        return new DefaultPredicate(this, Operand.AND, expression);
    }

    public Expression<?> getLeftExpression() {
        return this._leftExpression;
    }

    public Operand getOperand() {
        return this._operand;
    }

    public Expression<?> getRightExpression() {
        return this._rightExpression;
    }

    public boolean isWrapParentheses() {
        return this._wrapParentheses;
    }

    public Predicate not(Expression<Boolean> expression) {
        if (expression == null) {
            return this;
        }
        return new DefaultPredicate(this, Operand.NOT, expression);
    }

    public Predicate or(Expression<Boolean> expression) {
        if (expression == null) {
            return this;
        }
        return new DefaultPredicate(this, Operand.OR, expression);
    }

    @Override
    public void toSQL(Consumer<String> consumer, ASTNodeListener astNodeListener) {
        this.doToSQL(consumer, astNodeListener);
    }

    public Predicate withParentheses() {
        if (this._wrapParentheses) {
            return this;
        }
        return new DefaultPredicate(this._leftExpression, this._operand, this._rightExpression, true);
    }

    @Override
    protected void doToSQL(Consumer<String> consumer, ASTNodeListener astNodeListener) {
        LinkedList<Object> deque = new LinkedList<Object>();
        deque.push(this);
        ASTNode astNode = null;
        while ((astNode = (ASTNode)deque.poll()) != null) {
            if (astNode instanceof DefaultPredicate) {
                DefaultPredicate defaultPredicate;
                if (astNodeListener != null) {
                    astNodeListener.process(astNode);
                }
                if ((defaultPredicate = (DefaultPredicate)astNode).isWrapParentheses()) {
                    deque.push(new ASTNodeAdapter(")"));
                }
                deque.push(defaultPredicate.getRightExpression());
                Operand operand = defaultPredicate.getOperand();
                deque.push(new ASTNodeAdapter(operand.getStringWithSpaces()));
                deque.push(defaultPredicate.getLeftExpression());
                if (!defaultPredicate.isWrapParentheses()) continue;
                deque.push(new ASTNodeAdapter("("));
                continue;
            }
            astNode.toSQL(consumer, astNodeListener);
        }
    }

    private DefaultPredicate(Expression<?> leftExpression, Operand operand, Expression<?> rightExpression, boolean wrapParentheses) {
        this._leftExpression = Objects.requireNonNull(leftExpression);
        this._operand = Objects.requireNonNull(operand);
        this._rightExpression = Objects.requireNonNull(rightExpression);
        this._wrapParentheses = wrapParentheses;
    }

    private static class ASTNodeAdapter
    implements ASTNode {
        private final String _value;

        public void toSQL(Consumer<String> consumer, ASTNodeListener astNodeListener) {
            consumer.accept(this._value);
        }

        private ASTNodeAdapter(String value) {
            this._value = value;
        }
    }
}

