/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.sql.dsl.spi.expression;

import com.liferay.petra.sql.dsl.expression.Alias;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.sql.dsl.spi.expression.DefaultAlias;
import com.liferay.petra.sql.dsl.spi.expression.DefaultPredicate;
import com.liferay.petra.sql.dsl.spi.expression.NullExpression;
import com.liferay.petra.sql.dsl.spi.expression.Operand;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.petra.sql.dsl.spi.expression.ScalarList;
import com.liferay.petra.sql.dsl.spi.query.QueryExpression;
import com.liferay.petra.sql.dsl.spi.query.sort.DefaultOrderByExpression;

public interface DefaultExpression<T>
extends Expression<T> {
    default public Alias<T> as(String name) {
        return new DefaultAlias(this, name);
    }

    default public OrderByExpression ascending() {
        return new DefaultOrderByExpression(this, true);
    }

    default public OrderByExpression descending() {
        return new DefaultOrderByExpression(this, false);
    }

    default public Predicate eq(Expression<T> expression) {
        return new DefaultPredicate(this, Operand.EQUAL, expression);
    }

    default public Predicate eq(T value) {
        return this.eq((T)new Scalar<T>(value));
    }

    default public Predicate gt(Expression<T> expression) {
        return new DefaultPredicate(this, Operand.GREATER_THAN, expression);
    }

    default public Predicate gt(T value) {
        return this.gt((T)new Scalar<T>(value));
    }

    default public Predicate gte(Expression<T> expression) {
        return new DefaultPredicate(this, Operand.GREATER_THAN_OR_EQUAL, expression);
    }

    default public Predicate gte(T value) {
        return this.gte((T)new Scalar<T>(value));
    }

    default public Predicate in(DSLQuery dslQuery) {
        return new DefaultPredicate(this, Operand.IN, new QueryExpression(dslQuery));
    }

    default public Predicate in(T[] values) {
        return new DefaultPredicate(this, Operand.IN, new ScalarList<T>(values));
    }

    default public Predicate isNotNull() {
        return new DefaultPredicate(this, Operand.IS_NOT, NullExpression.INSTANCE);
    }

    default public Predicate isNull() {
        return new DefaultPredicate(this, Operand.IS, NullExpression.INSTANCE);
    }

    default public Predicate like(Expression<String> expression) {
        return new DefaultPredicate(this, Operand.LIKE, expression);
    }

    default public Predicate like(String value) {
        return this.like(new Scalar<String>(value));
    }

    default public Predicate lt(Expression<T> expression) {
        return new DefaultPredicate(this, Operand.LESS_THAN, expression);
    }

    default public Predicate lt(T value) {
        return this.lt((T)new Scalar<T>(value));
    }

    default public Predicate lte(Expression<T> expression) {
        return new DefaultPredicate(this, Operand.LESS_THAN_OR_EQUAL, expression);
    }

    default public Predicate lte(T value) {
        return this.lte((T)new Scalar<T>(value));
    }

    default public Predicate neq(Expression<T> expression) {
        return new DefaultPredicate(this, Operand.NOT_EQUAL, expression);
    }

    default public Predicate neq(T value) {
        return this.neq((T)new Scalar<T>(value));
    }

    default public Predicate notIn(DSLQuery dslQuery) {
        return new DefaultPredicate(this, Operand.NOT_IN, new QueryExpression(dslQuery));
    }

    default public Predicate notIn(T[] values) {
        return new DefaultPredicate(this, Operand.NOT_IN, new ScalarList<T>(values));
    }

    default public Predicate notLike(Expression<String> expression) {
        return new DefaultPredicate(this, Operand.NOT_LIKE, expression);
    }

    default public Predicate notLike(String value) {
        return this.like(new Scalar<String>(value));
    }
}

