/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.ext;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;

public class TimestampClientExtension
implements ClientSession.Extension {
    @Override
    public boolean send(ClientSession session, Message.Mutable message) {
        this.addTimestamp(message);
        return true;
    }

    @Override
    public boolean sendMeta(ClientSession session, Message.Mutable message) {
        this.addTimestamp(message);
        return true;
    }

    private void addTimestamp(Message.Mutable message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        message.put("timestamp", dateFormat.format(new Date()));
    }
}

