/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.salesforce.client.bulk;

import com.liferay.petra.salesforce.client.BaseSalesforceClientImpl;
import com.liferay.petra.salesforce.client.bulk.SalesforceBulkClient;
import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BulkConnection;
import com.sforce.async.JobInfo;
import com.sforce.async.QueryResultList;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import java.io.InputStream;

public class SalesforceBulkClientImpl
extends BaseSalesforceClientImpl
implements SalesforceBulkClient {
    private BulkConnection _bulkConnection;

    @Override
    public JobInfo abortJob(String jobInfoId, int retryCount) throws AsyncApiException, ConnectionException {
        try {
            BulkConnection bulkConnection = this._getBulkConnection();
            return bulkConnection.abortJob(jobInfoId);
        }
        catch (AsyncApiException asyncApiException) {
            return this.abortJob(jobInfoId, this.getRetryCount(retryCount, asyncApiException));
        }
    }

    @Override
    public JobInfo closeJob(String jobInfoId, int retryCount) throws AsyncApiException, ConnectionException {
        try {
            BulkConnection bulkConnection = this._getBulkConnection();
            return bulkConnection.closeJob(jobInfoId);
        }
        catch (AsyncApiException asyncApiException) {
            return this.closeJob(jobInfoId, this.getRetryCount(retryCount, asyncApiException));
        }
    }

    @Override
    public BatchInfo createBatchFromStream(JobInfo jobInfo, InputStream inputStream, int retryCount) throws AsyncApiException, ConnectionException {
        try {
            BulkConnection bulkConnection = this._getBulkConnection();
            return bulkConnection.createBatchFromStream(jobInfo, inputStream);
        }
        catch (AsyncApiException asyncApiException) {
            return this.createBatchFromStream(jobInfo, inputStream, this.getRetryCount(retryCount, asyncApiException));
        }
    }

    @Override
    public JobInfo createJob(JobInfo jobInfo, int retryCount) throws AsyncApiException, ConnectionException {
        try {
            BulkConnection bulkConnection = this._getBulkConnection();
            return bulkConnection.createJob(jobInfo);
        }
        catch (AsyncApiException asyncApiException) {
            return this.createJob(jobInfo, this.getRetryCount(retryCount, asyncApiException));
        }
    }

    @Override
    public BatchInfo getBatchInfo(String jobInfoId, String batchInfoId, int retryCount) throws AsyncApiException, ConnectionException {
        try {
            BulkConnection bulkConnection = this._getBulkConnection();
            return bulkConnection.getBatchInfo(jobInfoId, batchInfoId);
        }
        catch (AsyncApiException asyncApiException) {
            return this.getBatchInfo(jobInfoId, batchInfoId, this.getRetryCount(retryCount, asyncApiException));
        }
    }

    @Override
    public QueryResultList getQueryResultList(String jobInfoId, String batchInfoId, int retryCount) throws AsyncApiException, ConnectionException {
        try {
            BulkConnection bulkConnection = this._getBulkConnection();
            return bulkConnection.getQueryResultList(jobInfoId, batchInfoId);
        }
        catch (AsyncApiException asyncApiException) {
            return this.getQueryResultList(jobInfoId, batchInfoId, this.getRetryCount(retryCount, asyncApiException));
        }
    }

    @Override
    public InputStream getQueryResultStream(String jobInfoId, String batchInfoId, String queryResultId, int retryCount) throws AsyncApiException, ConnectionException {
        try {
            BulkConnection bulkConnection = this._getBulkConnection();
            return bulkConnection.getQueryResultStream(jobInfoId, batchInfoId, queryResultId);
        }
        catch (AsyncApiException asyncApiException) {
            return this.getQueryResultStream(jobInfoId, batchInfoId, queryResultId, this.getRetryCount(retryCount, asyncApiException));
        }
    }

    private BulkConnection _getBulkConnection() throws AsyncApiException, ConnectionException {
        if (this._bulkConnection != null) {
            return this._bulkConnection;
        }
        PartnerConnection partnerConnection = this.getPartnerConnection();
        ConnectorConfig connectorConfig = partnerConnection.getConfig();
        connectorConfig.setCompression(true);
        StringBuilder sb = new StringBuilder();
        String serviceEndpoint = connectorConfig.getServiceEndpoint();
        sb.append(serviceEndpoint.substring(0, serviceEndpoint.indexOf("/Soap/")));
        sb.append("/async/");
        String authEndpoint = connectorConfig.getAuthEndpoint();
        sb.append(authEndpoint.substring(authEndpoint.lastIndexOf("/") + 1));
        connectorConfig.setRestEndpoint(sb.toString());
        connectorConfig.setSessionId(connectorConfig.getSessionId());
        this._bulkConnection = new BulkConnection(connectorConfig);
        return this._bulkConnection;
    }
}

