/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.log4j.internal;

import java.util.Objects;
import java.util.Properties;
import org.apache.log4j.Layout;
import org.apache.log4j.bridge.AppenderWrapper;
import org.apache.log4j.bridge.LayoutAdapter;
import org.apache.log4j.bridge.LayoutWrapper;
import org.apache.log4j.config.PropertiesConfiguration;
import org.apache.log4j.xml.XmlConfiguration;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Plugin(category="Log4j Builder", name="org.apache.log4j.rolling.RollingFileAppender")
public class RollingFileAppenderBuilder
extends org.apache.log4j.builders.appender.RollingFileAppenderBuilder {
    public org.apache.log4j.Appender parseAppender(Element appenderElement, XmlConfiguration xmlConfiguration) {
        RollingFileAppender.Builder builder = RollingFileAppender.newBuilder();
        builder.setName(appenderElement.getAttribute("name")).setConfiguration((Configuration)xmlConfiguration);
        XmlConfiguration.forEachElement((NodeList)appenderElement.getChildNodes(), currentElement -> {
            String tagName = currentElement.getTagName();
            if (Objects.equals(tagName, "layout")) {
                Layout layout = xmlConfiguration.parseLayout(currentElement);
                if (layout instanceof LayoutWrapper) {
                    LayoutWrapper layoutWrapper = (LayoutWrapper)layout;
                    builder.setLayout(layoutWrapper.getLayout());
                } else if (layout != null) {
                    builder.setLayout((org.apache.logging.log4j.core.Layout)new LayoutAdapter(layout));
                }
            } else if (Objects.equals(tagName, "rollingPolicy")) {
                XmlConfiguration.forEachElement((NodeList)currentElement.getElementsByTagName("param"), paramElement -> {
                    String paramName = paramElement.getAttribute("name");
                    if (Objects.equals(paramName, "FileNamePattern")) {
                        builder.withFilePattern(paramElement.getAttribute("value"));
                    }
                });
            }
        });
        TimeBasedTriggeringPolicy.Builder timeBasedTriggeringPolicyBuilder = TimeBasedTriggeringPolicy.newBuilder();
        builder.withPolicy((TriggeringPolicy)timeBasedTriggeringPolicyBuilder.build());
        DirectWriteRolloverStrategy.Builder directWriteRolloverStrategyBuilder = DirectWriteRolloverStrategy.newBuilder();
        builder.withStrategy((RolloverStrategy)directWriteRolloverStrategyBuilder.withConfig((Configuration)xmlConfiguration).build());
        return new AppenderWrapper((Appender)builder.build());
    }

    public org.apache.log4j.Appender parseAppender(String name, String appenderPrefix, String layoutPrefix, String filterPrefix, Properties props, PropertiesConfiguration configuration) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

