/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.log4j.internal;

import com.liferay.petra.log4j.internal.CentralizedConfiguration;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.xml.XmlConfiguration;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Log4jConfigUtil {
    private static final Log _log = LogFactoryUtil.getLog(Log4jConfigUtil.class);
    private static final CentralizedConfiguration _centralizedConfiguration;
    private static final LoggerContext _loggerContext;
    private static final List<String> _reservedAppenderNames;

    public static Map<String, String> configureLog4J(String xmlContent, String ... removedAppenderNames) {
        try {
            Object abstractConfiguration;
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read((Reader)new UnsyncStringReader(xmlContent));
            Element rootElement = document.getRootElement();
            HashMap<String, String> priorities = new HashMap<String, String>();
            if (Objects.equals("Configuration", rootElement.getName())) {
                if (!GetterUtil.getBoolean((String)rootElement.attributeValue("strict"))) {
                    _log.error((Object)"<Configuration> strict attribute requires true");
                    return Collections.emptyMap();
                }
                for (Element element : rootElement.elements()) {
                    Log4jConfigUtil._removeAppender(element, "AppenderRef", "Appender", removedAppenderNames);
                    for (Element childElement : element.elements("Logger")) {
                        priorities.put(childElement.attributeValue("name"), childElement.attributeValue("level"));
                    }
                }
                if (removedAppenderNames.length > 0) {
                    xmlContent = document.asXML();
                }
                abstractConfiguration = new org.apache.logging.log4j.core.config.xml.XmlConfiguration(_loggerContext, new ConfigurationSource((InputStream)new UnsyncByteArrayInputStream(xmlContent.getBytes("UTF-8")))){

                    protected void setToDefault() {
                    }
                };
            } else {
                Log4jConfigUtil._removeAppender(rootElement, "appender-ref", "appender", removedAppenderNames);
                for (Element childElement : rootElement.elements("category")) {
                    Element priorityElement = childElement.element("priority");
                    priorities.put(childElement.attributeValue("name"), priorityElement.attributeValue("value"));
                }
                if (removedAppenderNames.length > 0 || Log4jConfigUtil._renameLog4j1Appenders(rootElement)) {
                    xmlContent = document.asXML();
                }
                abstractConfiguration = new XmlConfiguration(_loggerContext, new ConfigurationSource((InputStream)new UnsyncByteArrayInputStream(xmlContent.getBytes("UTF-8"))), 0){

                    protected void setToDefault() {
                    }
                };
            }
            _centralizedConfiguration.addConfiguration((AbstractConfiguration)abstractConfiguration);
            return priorities;
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return Collections.emptyMap();
        }
    }

    public static java.util.logging.Level getJDKLevel(String levelString) {
        if (StringUtil.equalsIgnoreCase((String)levelString, (String)Level.DEBUG.toString())) {
            return java.util.logging.Level.FINE;
        }
        if (StringUtil.equalsIgnoreCase((String)levelString, (String)Level.ERROR.toString())) {
            return java.util.logging.Level.SEVERE;
        }
        if (StringUtil.equalsIgnoreCase((String)levelString, (String)Level.WARN.toString())) {
            return java.util.logging.Level.WARNING;
        }
        return java.util.logging.Level.INFO;
    }

    public static Map<String, String> getPriorities() {
        HashMap<String, String> priorities = new HashMap<String, String>();
        Map loggerConfigs = _centralizedConfiguration.getLoggers();
        for (LoggerConfig loggerConfig : loggerConfigs.values()) {
            String loggerConfigName = loggerConfig.getName();
            if (Objects.equals(loggerConfigName, "")) continue;
            priorities.put(loggerConfigName, String.valueOf(loggerConfig.getLevel()));
        }
        return priorities;
    }

    public static void setLevel(String name, String priority) {
        Level level = Level.toLevel((String)priority);
        LoggerConfig loggerConfig = _centralizedConfiguration.getLogger(name);
        if (loggerConfig == null) {
            loggerConfig = new LoggerConfig(name, level, true);
            _centralizedConfiguration.addLogger(name, loggerConfig);
        } else {
            loggerConfig.setLevel(level);
        }
        _loggerContext.updateLoggers();
    }

    public static void shutdownLog4J() {
        LogManager.shutdown();
    }

    private static String _getLog4j1AppenderSuffix(Element element) {
        String suffix = StringUtil.randomString();
        for (Element childElement : element.elements("rollingPolicy")) {
            for (Element paramElement : childElement.elements("param")) {
                if (!Objects.equals(paramElement.attributeValue("name"), "FileNamePattern")) continue;
                String value = paramElement.attributeValue("value");
                value = value.substring(value.lastIndexOf("/") + 1);
                suffix = value.substring(0, value.indexOf("."));
            }
        }
        return "_".concat(suffix);
    }

    private static void _removeAppender(Element parentElement, String appenderRefTagName, String appenderTagName, String ... removedAppenderNames) {
        if (removedAppenderNames.length == 0) {
            return;
        }
        for (Element element : parentElement.elements()) {
            for (String appenderName : removedAppenderNames) {
                if (Objects.equals(appenderTagName, element.getName()) && Objects.equals(appenderName, element.attributeValue("name"))) {
                    parentElement.remove(element);
                }
                for (Element childElement : element.elements()) {
                    if (!Objects.equals(appenderRefTagName, childElement.getName()) || !Objects.equals(appenderName, childElement.attributeValue("ref"))) continue;
                    element.remove(childElement);
                }
            }
        }
    }

    private static boolean _renameLog4j1Appenders(Element parentElement) {
        HashMap<String, String> newAppenderNames = new HashMap<String, String>();
        for (Element element : parentElement.elements("appender")) {
            String appenderName = element.attributeValue("name");
            if (!_reservedAppenderNames.contains(appenderName)) continue;
            String newAppenderName = appenderName.concat(Log4jConfigUtil._getLog4j1AppenderSuffix(element));
            newAppenderNames.put(appenderName, newAppenderName);
            element.addAttribute("name", newAppenderName);
        }
        if (newAppenderNames.isEmpty()) {
            return false;
        }
        for (Element element : parentElement.elements()) {
            for (Element childElement : element.elements("appender-ref")) {
                String newAppenderName = (String)newAppenderNames.get(childElement.attributeValue("ref"));
                if (newAppenderName == null) continue;
                childElement.addAttribute("ref", newAppenderName);
            }
        }
        return true;
    }

    static {
        _loggerContext = LoggerContext.getContext();
        _reservedAppenderNames = Arrays.asList("TEXT_FILE", "XML_FILE");
        PluginManager.addPackage((String)"com.liferay.petra.log4j.internal");
        _centralizedConfiguration = new CentralizedConfiguration(_loggerContext);
        _loggerContext.setConfiguration((Configuration)_centralizedConfiguration);
    }
}

