/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.log4j.internal;

import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.NullAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.Constants;

@Plugin(category="Core", elementType="appender", name="CompanyLogRouting", printObject=true)
public final class CompanyLogRoutingAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "CompanyLogRouting";
    private static final boolean _COMPANY_LOG_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"company.log.enabled"));
    private final boolean _advertise;
    private final String _advertiseUri;
    private final boolean _append;
    private final Map<Long, Appender> _appenders = new ConcurrentHashMap<Long, Appender>();
    private final boolean _bufferedIo;
    private final int _bufferSize;
    private final boolean _createOnDemand;
    private final String _fileGroup;
    private final String _fileName;
    private final String _fileOwner;
    private final String _filePattern;
    private final String _filePermissions;
    private final boolean _immediateFlush;
    private final boolean _locking;
    private final RolloverStrategy _rolloverStrategy;
    private final TriggeringPolicy _triggeringPolicy;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public void append(LogEvent logEvent) {
        if (!_COMPANY_LOG_ENABLED) {
            return;
        }
        Appender appender = this._appenders.computeIfAbsent(CompanyThreadLocal.getCompanyId(), this::_createAppender);
        appender.append(logEvent);
    }

    private CompanyLogRoutingAppender(boolean advertise, String advertiseUri, boolean append, boolean bufferedIo, int bufferSize, boolean createOnDemand, String fileGroup, String fileName, String fileOwner, String filePattern, String filePermissions, Filter filter, boolean immediateFlush, Layout<? extends Serializable> layout, boolean locking, String name, RolloverStrategy rolloverStrategy, TriggeringPolicy triggeringPolicy) {
        super(name, filter, layout, true, null);
        this._advertise = advertise;
        this._advertiseUri = advertiseUri;
        this._append = append;
        this._bufferedIo = bufferedIo;
        this._bufferSize = bufferSize;
        this._createOnDemand = createOnDemand;
        this._fileGroup = fileGroup;
        this._fileName = fileName;
        this._fileOwner = fileOwner;
        this._filePattern = filePattern;
        this._filePermissions = filePermissions;
        this._immediateFlush = immediateFlush;
        this._locking = locking;
        this._rolloverStrategy = rolloverStrategy;
        this._triggeringPolicy = triggeringPolicy;
    }

    private Appender _createAppender(long companyId) {
        RollingFileAppender.Builder builder = RollingFileAppender.newBuilder();
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext();
        builder.setConfiguration(loggerContext.getConfiguration());
        builder.setIgnoreExceptions(this.ignoreExceptions());
        builder.setLayout(this.getLayout());
        String name = companyId + "-" + this.getName();
        builder.setName(name);
        builder.withAdvertise(this._advertise);
        builder.withAdvertiseUri(this._advertiseUri);
        builder.withAppend(this._append);
        builder.withBufferedIo(this._bufferedIo);
        builder.withBufferSize(this._bufferSize);
        builder.withCreateOnDemand(this._createOnDemand);
        builder.withFileGroup(this._fileGroup);
        builder.withFileName(this._fileName);
        builder.withFileOwner(this._fileOwner);
        builder.withFilePattern(StringUtil.replace((String)this._filePattern, (String)"@company.id@", (String)String.valueOf(companyId)));
        builder.withFilePermissions(this._filePermissions);
        builder.withImmediateFlush(this._immediateFlush);
        builder.withLocking(this._locking);
        builder.withPolicy(this._triggeringPolicy);
        if (this._rolloverStrategy instanceof DirectWriteRolloverStrategy) {
            DirectWriteRolloverStrategy directWriteRolloverStrategy = (DirectWriteRolloverStrategy)this._rolloverStrategy;
            DirectWriteRolloverStrategy.Builder directWriteRolloverStrategyBuilder = DirectWriteRolloverStrategy.newBuilder();
            directWriteRolloverStrategyBuilder.withCompressionLevelStr(String.valueOf(directWriteRolloverStrategy.getCompressionLevel()));
            directWriteRolloverStrategyBuilder.withConfig(loggerContext.getConfiguration());
            List customActions = directWriteRolloverStrategy.getCustomActions();
            directWriteRolloverStrategyBuilder.withCustomActions(customActions.toArray(new Action[0]));
            directWriteRolloverStrategyBuilder.withMaxFiles(String.valueOf(directWriteRolloverStrategy.getMaxFiles()));
            directWriteRolloverStrategyBuilder.withStopCustomActionsOnError(directWriteRolloverStrategy.isStopCustomActionsOnError());
            PatternProcessor patternProcessor = directWriteRolloverStrategy.getTempCompressedFilePattern();
            if (patternProcessor != null) {
                directWriteRolloverStrategyBuilder.withTempCompressedFilePattern(patternProcessor.getPattern());
            }
            builder.withStrategy((RolloverStrategy)directWriteRolloverStrategyBuilder.build());
        } else {
            builder.withStrategy(this._rolloverStrategy);
        }
        RollingFileAppender appender = builder.build();
        if (appender != null) {
            appender.start();
            return appender;
        }
        return NullAppender.createAppender((String)name);
    }

    public static class Builder
    extends AbstractAppender.Builder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<CompanyLogRoutingAppender> {
        @PluginBuilderAttribute(value="advertise")
        private boolean _advertise;
        @PluginBuilderAttribute(value="advertiseUri")
        private String _advertiseUri;
        @PluginBuilderAttribute(value="append")
        private boolean _append = true;
        @PluginBuilderAttribute(value="bufferedIo")
        private boolean _bufferedIo = true;
        @PluginBuilderAttribute(value="bufferSize")
        private int _bufferSize = Constants.ENCODER_BYTE_BUFFER_SIZE;
        @PluginBuilderAttribute(value="createOnDemand")
        private boolean _createOnDemand;
        @PluginBuilderAttribute(value="fileGroup")
        private String _fileGroup;
        @PluginBuilderAttribute(value="fileName")
        private String _fileName;
        @PluginBuilderAttribute(value="fileOwner")
        private String _fileOwner;
        @PluginBuilderAttribute(value="filePattern")
        @Required
        private String _filePattern;
        @PluginBuilderAttribute(value="filePermissions")
        private String _filePermissions;
        @PluginBuilderAttribute(value="immediateFlush")
        private boolean _immediateFlush = true;
        @PluginBuilderAttribute(value="locking")
        private boolean _locking;
        @PluginElement(value="Strategy")
        private RolloverStrategy _rolloverStrategy;
        @PluginElement(value="Policy")
        @Required
        private TriggeringPolicy _triggeringPolicy;

        public CompanyLogRoutingAppender build() {
            return new CompanyLogRoutingAppender(this._advertise, this._advertiseUri, this._append, this._bufferedIo, this._bufferSize, this._createOnDemand, this._fileGroup, this._fileName, this._fileOwner, this._filePattern, this._filePermissions, this.getFilter(), this._immediateFlush, this.getLayout(), this._locking, this.getName(), this._rolloverStrategy, this._triggeringPolicy);
        }
    }
}

