/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.log4j.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.AbstractFilterable;

public class CentralizedConfiguration
extends AbstractConfiguration {
    private static final Field _appenderRefsField;

    public CentralizedConfiguration(LoggerContext loggerContext) {
        super(loggerContext, ConfigurationSource.COMPOSITE_SOURCE);
    }

    public void addConfiguration(AbstractConfiguration abstractConfiguration) {
        if (abstractConfiguration.getState() != LifeCycle.State.INITIALIZING) {
            return;
        }
        abstractConfiguration.initialize();
        Map properties = this.getProperties();
        properties.putAll(abstractConfiguration.getProperties());
        this._aggregateAppenders(abstractConfiguration);
        this._aggregateFilter((AbstractFilterable)this, (AbstractFilterable)abstractConfiguration);
        this._aggregateLoggerConfigs(abstractConfiguration);
        LoggerContext loggerContext = this.getLoggerContext();
        loggerContext.updateLoggers();
    }

    public void start() {
        LoggerConfig rootLoggerConfig = this.getRootLogger();
        rootLoggerConfig.start();
        this.addLogger("", rootLoggerConfig);
        this.setStarted();
    }

    private void _aggregateAppenders(AbstractConfiguration abstractConfiguration) {
        Map currentAppenders = this.getAppenders();
        Map newAppenders = abstractConfiguration.getAppenders();
        for (Appender newAppender : newAppenders.values()) {
            newAppender.start();
            String appenderName = newAppender.getName();
            Appender currentAppender = currentAppenders.put(appenderName, newAppender);
            if (currentAppender == null) continue;
            Map loggerConfigs = this.getLoggers();
            for (LoggerConfig loggerConfig : loggerConfigs.values()) {
                Map appenders = loggerConfig.getAppenders();
                if (!appenders.containsKey(appenderName)) continue;
                AppenderRef appenderRef = this._getAppenderRef(appenderName, loggerConfig);
                loggerConfig.removeAppender(appenderName);
                if (appenderRef == null) {
                    loggerConfig.addAppender(newAppender, null, null);
                    continue;
                }
                loggerConfig.addAppender(newAppender, appenderRef.getLevel(), appenderRef.getFilter());
            }
            currentAppender.stop();
        }
    }

    private void _aggregateFilter(AbstractFilterable currentAbstractFilterable, AbstractFilterable newAbstractFilterable) {
        Filter filter = newAbstractFilterable.getFilter();
        if (filter != null) {
            filter.start();
            currentAbstractFilterable.addFilter(filter);
        }
    }

    private void _aggregateLoggerConfigs(AbstractConfiguration abstractConfiguration) {
        LoggerConfig newRootLoggerConfig = abstractConfiguration.getLogger("");
        if (newRootLoggerConfig != null) {
            this._mergeLoggerConfig(this.getRootLogger(), newRootLoggerConfig);
        }
        Map newLoggerConfigs = abstractConfiguration.getLoggers();
        for (LoggerConfig newLoggerConfig : newLoggerConfigs.values()) {
            String name = newLoggerConfig.getName();
            if (Objects.equals(name, "")) continue;
            LoggerConfig currentLoggerConfig = this.getLogger(name);
            if (currentLoggerConfig != null) {
                this._mergeLoggerConfig(currentLoggerConfig, newLoggerConfig);
                continue;
            }
            this.addLogger(name, newLoggerConfig);
            newLoggerConfig.start();
        }
    }

    private AppenderRef _getAppenderRef(String name, LoggerConfig loggerConfig) {
        for (AppenderRef appenderRef : loggerConfig.getAppenderRefs()) {
            if (!Objects.equals(appenderRef.getRef(), name)) continue;
            return appenderRef;
        }
        return null;
    }

    private void _mergeLoggerConfig(LoggerConfig currentLoggerConfig, LoggerConfig newLoggerConfig) {
        currentLoggerConfig.setLevel(newLoggerConfig.getLevel());
        currentLoggerConfig.setAdditive(newLoggerConfig.isAdditive());
        this._aggregateFilter((AbstractFilterable)currentLoggerConfig, (AbstractFilterable)newLoggerConfig);
        Map currentAppenders = currentLoggerConfig.getAppenders();
        Map newAppenders = newLoggerConfig.getAppenders();
        ArrayList<AppenderRef> currentAppenderRefs = new ArrayList<AppenderRef>(currentLoggerConfig.getAppenderRefs());
        try {
            _appenderRefsField.set(currentLoggerConfig, currentAppenderRefs);
        }
        catch (IllegalAccessException illegalAccessException) {
            ReflectionUtil.throwException((Throwable)illegalAccessException);
        }
        for (Appender newAppender : newAppenders.values()) {
            String name = newAppender.getName();
            AppenderRef newAppenderRef = this._getAppenderRef(name, newLoggerConfig);
            if (currentAppenders.containsKey(name)) {
                currentLoggerConfig.removeAppender(name);
                Iterator currentAppenderRefIterator = currentAppenderRefs.iterator();
                while (currentAppenderRefIterator.hasNext()) {
                    AppenderRef currentAppenderRef = (AppenderRef)currentAppenderRefIterator.next();
                    if (!Objects.equals(currentAppenderRef.getRef(), name)) continue;
                    currentAppenderRefIterator.remove();
                    break;
                }
            }
            if (newAppenderRef == null) {
                currentLoggerConfig.addAppender(newAppender, null, null);
                continue;
            }
            currentLoggerConfig.addAppender(newAppender, newAppenderRef.getLevel(), newAppenderRef.getFilter());
            currentAppenderRefs.add(newAppenderRef);
        }
    }

    static {
        try {
            _appenderRefsField = ReflectionUtil.getDeclaredField(LoggerConfig.class, (String)"appenderRefs");
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

