/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.log4j;

import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.log4j.internal.Log4jConfigUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class Log4JUtil {
    private static final Log _log = LogFactoryUtil.getLog(Log4JUtil.class);
    private static final Map<String, String> _customLogSettings = new ConcurrentHashMap<String, String>();
    private static String _liferayHome;

    public static void configureLog4J(ClassLoader classLoader) {
        block3: {
            Log4JUtil.configureLog4J(classLoader.getResource("META-INF/portal-log4j.xml"));
            try {
                Enumeration<URL> enumeration = classLoader.getResources("META-INF/portal-log4j-ext.xml");
                while (enumeration.hasMoreElements()) {
                    Log4JUtil.configureLog4J(enumeration.nextElement());
                }
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to load portal-log4j-ext.xml", (Throwable)ioException);
            }
        }
    }

    public static void configureLog4J(URL url) {
        if (url == null) {
            return;
        }
        String urlContent = null;
        try {
            InputStream inputStream = url.openStream();
            Object object = null;
            try {
                urlContent = StreamUtil.toString((InputStream)inputStream, (String)"UTF-8");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return;
        }
        urlContent = StringUtil.replace((String)urlContent, (String)"@liferay.home@", (String)Log4JUtil._getLiferayHome());
        Map<String, String> priorities = null;
        priorities = ServerDetector.getServerId() != null ? Log4jConfigUtil.configureLog4J(urlContent, new String[0]) : Log4jConfigUtil.configureLog4J(urlContent, "TEXT_FILE", "XML_FILE");
        for (Map.Entry entry : priorities.entrySet()) {
            Logger jdkLogger = Logger.getLogger((String)entry.getKey());
            jdkLogger.setLevel(Log4jConfigUtil.getJDKLevel((String)entry.getValue()));
        }
    }

    public static Map<String, String> getCustomLogSettings() {
        return new HashMap<String, String>(_customLogSettings);
    }

    @Deprecated
    public static String getOriginalLevel(String className) {
        Map<String, String> priorities = Log4jConfigUtil.getPriorities();
        String logLevelString = priorities.get(className);
        if (Validator.isNull((String)logLevelString)) {
            return "ALL";
        }
        return logLevelString;
    }

    public static Map<String, String> getPriorities() {
        return Log4jConfigUtil.getPriorities();
    }

    public static void initLog4J(String serverId, String liferayHome, ClassLoader classLoader, LogFactory logFactory, Map<String, String> customLogSettings) {
        System.setProperty("server.detector.server.id", serverId);
        _liferayHome = Log4JUtil._escapeXMLAttribute(liferayHome);
        Log4JUtil.configureLog4J(classLoader);
        try {
            LogFactoryUtil.setLogFactory((LogFactory)logFactory);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        for (Map.Entry<String, String> entry : customLogSettings.entrySet()) {
            Log4JUtil.setLevel(entry.getKey(), entry.getValue(), false);
        }
    }

    public static void setLevel(String name, String priority, boolean custom) {
        Log4jConfigUtil.setLevel(name, priority);
        Logger jdkLogger = Logger.getLogger(name);
        jdkLogger.setLevel(Log4jConfigUtil.getJDKLevel(priority));
        if (custom) {
            _customLogSettings.put(name, priority);
        }
    }

    public static void shutdownLog4J() {
        Log4jConfigUtil.shutdownLog4J();
    }

    private static String _escapeXMLAttribute(String s) {
        return StringUtil.replace((String)s, (char[])new char[]{'&', '\'', '<', '\"'}, (String[])new String[]{"&amp;", "&apos;", "&lt;", "&quot;"});
    }

    private static String _getLiferayHome() {
        if (_liferayHome == null) {
            _liferayHome = Log4JUtil._escapeXMLAttribute(PropsUtil.get((String)"liferay.home"));
        }
        return _liferayHome;
    }
}

