/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.json.web.service.client.internal;

import com.liferay.petra.json.web.service.client.BaseJSONWebServiceClientImpl;
import com.liferay.petra.json.web.service.client.JSONWebServiceTransportException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.nio.reactor.IOReactorException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(factory="JSONWebServiceClient", service={})
public class JSONWebServiceClientImpl
extends BaseJSONWebServiceClientImpl {
    private static final Logger _logger = LoggerFactory.getLogger(JSONWebServiceClientImpl.class);

    @Activate
    public void activate(Map<String, Object> properties) throws IOReactorException {
        this._setHeaders(this._getString("headers", properties));
        this.setHostName(this._getString("hostName", properties));
        this.setHostPort(Integer.parseInt(this._getString("hostPort", properties)));
        this.setKeyStore((KeyStore)properties.get("keyStore"));
        this.setLogin(this._getString("login", properties));
        if (properties.containsKey("maxAttempts")) {
            this.setMaxAttempts(Integer.parseInt(this._getString("maxAttempts", properties)));
        }
        this.setPassword(this._getString("password", properties));
        this.setProtocol(this._getString("protocol", properties));
        if (properties.containsKey("proxyAuthType")) {
            this.setProxyAuthType(this._getString("proxyAuthType", properties));
            this.setProxyDomain(this._getString("proxyDomain", properties));
            this.setProxyWorkstation(this._getString("proxyWorkstation", properties));
        }
        if (properties.containsKey("proxyHostName")) {
            this.setProxyHostName(this._getString("proxyHostName", properties));
            this.setProxyHostPort(Integer.parseInt(this._getString("proxyHostPort", properties)));
            this.setProxyLogin(this._getString("proxyLogin", properties));
            this.setProxyPassword(this._getString("proxyPassword", properties));
        }
        this.afterPropertiesSet();
    }

    @Override
    public void afterPropertiesSet() throws IOReactorException {
        super.afterPropertiesSet();
    }

    @Deactivate
    protected void deactivate() {
        super.destroy();
    }

    @Override
    protected void signRequest(HttpRequestBase httpRequestBase) throws JSONWebServiceTransportException.SigningFailure {
    }

    private String _getString(String key, Map<String, Object> properties) {
        if (!properties.containsKey(key)) {
            return null;
        }
        return String.valueOf(properties.get(key));
    }

    private void _setHeaders(String headersString) {
        if (headersString == null) {
            return;
        }
        if ((headersString = headersString.trim()).length() < 3) {
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String header : headersString.split(";")) {
            String[] headerParts = header.split("=");
            if (headerParts.length != 2) {
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug("Ignoring invalid header " + header);
                continue;
            }
            headers.put(headerParts[0], headerParts[1]);
        }
        this.setHeaders(headers);
    }
}

