/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.json.web.service.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.liferay.petra.json.web.service.client.JSONWebServiceClient;
import com.liferay.petra.json.web.service.client.JSONWebServiceInvocationException;
import com.liferay.petra.json.web.service.client.JSONWebServiceSerializeException;
import com.liferay.petra.json.web.service.client.JSONWebServiceTransportException;
import com.liferay.petra.json.web.service.client.internal.AsyncHttpClient;
import com.liferay.petra.json.web.service.client.internal.IdleConnectionMonitorThread;
import com.liferay.petra.json.web.service.client.internal.JSONWebServiceClientImpl;
import com.liferay.petra.json.web.service.client.internal.X509TrustManagerImpl;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJSONWebServiceClientImpl
implements JSONWebServiceClient {
    private static final Charset _CHARSET = Charset.forName("UTF-8");
    private static final Logger _logger = LoggerFactory.getLogger(JSONWebServiceClientImpl.class);
    private AsyncHttpClient _asyncHttpClient;
    private String _contextPath;
    private final Pattern _errorMessagePattern = Pattern.compile("errorCode\":\\s*(\\d+).+message\":.+status\":\\s*(\\d+)");
    private Map<String, String> _headers = Collections.emptyMap();
    private String _hostName;
    private int _hostPort = 80;
    private IdleConnectionMonitorThread _idleConnectionMonitorThread;
    private KeyStore _keyStore;
    private String _login;
    private int _maxAttempts;
    private String _oAuthAccessSecret;
    private String _oAuthAccessToken;
    private String _oAuthConsumerKey;
    private String _oAuthConsumerSecret;
    private ObjectMapper _objectMapper = new ObjectMapper();
    private String _password;
    private String _protocol = "http";
    private String _proxyAuthType;
    private String _proxyDomain;
    private String _proxyHostName;
    private int _proxyHostPort;
    private String _proxyLogin;
    private String _proxyPassword;
    private String _proxyWorkstation;
    private final Pattern _statusPattern = Pattern.compile("status\":(\\d+)");

    public void afterPropertiesSet() throws IOReactorException {
        HttpAsyncClientBuilder httpAsyncClientBuilder = HttpAsyncClients.custom();
        httpAsyncClientBuilder = httpAsyncClientBuilder.useSystemProperties();
        PoolingNHttpClientConnectionManager nHttpClientConnectionManager = this.getPoolingNHttpClientConnectionManager();
        httpAsyncClientBuilder.setConnectionManager((NHttpClientConnectionManager)nHttpClientConnectionManager);
        httpAsyncClientBuilder.setDefaultCredentialsProvider(this._getCredentialsProvider());
        this.setProxyHost(httpAsyncClientBuilder);
        try {
            CloseableHttpAsyncClient closeableHttpAsyncClient = httpAsyncClientBuilder.build();
            closeableHttpAsyncClient.start();
            this._asyncHttpClient = new AsyncHttpClient(closeableHttpAsyncClient, this._maxAttempts);
            this._idleConnectionMonitorThread = new IdleConnectionMonitorThread((NHttpClientConnectionManager)nHttpClientConnectionManager);
            this._idleConnectionMonitorThread.start();
            if (_logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Configured client for ");
                sb.append(this._protocol);
                sb.append("://");
                sb.append(this._hostName);
                sb.append(":");
                sb.append(this._hostPort);
                _logger.debug(sb.toString());
            }
        }
        catch (Exception e) {
            _logger.error("Unable to configure client", (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        try {
            this._asyncHttpClient.close();
        }
        catch (IOException ioe) {
            _logger.error("Unable to close client", (Throwable)ioe);
        }
        this._asyncHttpClient = null;
        this._idleConnectionMonitorThread.shutdown();
    }

    @Override
    public String doDelete(String url, Map<String, String> parameters) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doDelete(url, parameters, Collections.<String, String>emptyMap());
    }

    @Override
    public String doDelete(String url, Map<String, String> parameters, Map<String, String> headers) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        List<NameValuePair> nameValuePairs;
        if (!this.isNull(this._contextPath)) {
            url = this._contextPath + url;
        }
        if (!(nameValuePairs = this.toNameValuePairs(parameters)).isEmpty()) {
            String queryString = URLEncodedUtils.format(nameValuePairs, (Charset)_CHARSET);
            url = url + "?" + queryString;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Sending DELETE request to " + this._login + "@" + this._hostName + url);
            this.log("HTTP headers", headers);
            this.log("HTTP parameters", parameters);
        }
        HttpDelete httpDelete = new HttpDelete(url);
        this.addHeaders((HttpMessage)httpDelete, headers);
        return this.execute((HttpRequestBase)httpDelete);
    }

    @Override
    public String doDelete(String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 0; i < parametersArray.length; i += 2) {
            parameters.put(parametersArray[i], parametersArray[i + 1]);
        }
        return this.doDelete(url, parameters, Collections.<String, String>emptyMap());
    }

    @Override
    public String doGet(String url, Map<String, String> parameters) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doGet(url, parameters, Collections.<String, String>emptyMap());
    }

    @Override
    public String doGet(String url, Map<String, String> parameters, Map<String, String> headers) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        List<NameValuePair> nameValuePairs;
        if (!this.isNull(this._contextPath)) {
            url = this._contextPath + url;
        }
        if (!(nameValuePairs = this.toNameValuePairs(parameters)).isEmpty()) {
            String queryString = URLEncodedUtils.format(nameValuePairs, (Charset)_CHARSET);
            url = url + "?" + queryString;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Sending GET request to " + this._login + "@" + this._hostName + url);
            this.log("HTTP headers", headers);
            this.log("HTTP parameters", parameters);
        }
        HttpGet httpGet = new HttpGet(url);
        this.addHeaders((HttpMessage)httpGet, headers);
        return this.execute((HttpRequestBase)httpGet);
    }

    @Override
    public String doGet(String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 0; i < parametersArray.length; i += 2) {
            parameters.put(parametersArray[i], parametersArray[i + 1]);
        }
        return this.doGet(url, parameters, Collections.<String, String>emptyMap());
    }

    @Override
    public <V, T> List<V> doGetToList(Class<T> clazz, String url, Map<String, String> parameters, Map<String, String> headers) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        String json = this.doGet(url, parameters, headers);
        if (json == null) {
            return Collections.emptyList();
        }
        try {
            TypeFactory typeFactory = this._objectMapper.getTypeFactory();
            ArrayList list = new ArrayList();
            CollectionType javaType = typeFactory.constructCollectionType(list.getClass(), clazz);
            return (List)this._objectMapper.readValue(json, (JavaType)javaType);
        }
        catch (IOException ioe) {
            throw this._getJSONWebServiceSerializeException(json, clazz);
        }
    }

    @Override
    public <V, T> List<V> doGetToList(Class<T> clazz, String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 0; i < parametersArray.length; i += 2) {
            parameters.put(parametersArray[i], parametersArray[i + 1]);
        }
        return this.doGetToList(clazz, url, parameters, Collections.<String, String>emptyMap());
    }

    @Override
    public <T> T doGetToObject(Class<T> clazz, String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        String json = this.doGet(url, parametersArray);
        if (json == null) {
            return null;
        }
        try {
            return (T)this._objectMapper.readValue(json, clazz);
        }
        catch (IOException ioe) {
            throw this._getJSONWebServiceSerializeException(json, clazz);
        }
    }

    @Override
    public String doPost(String url, Map<String, String> parameters) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doPost(url, parameters, Collections.<String, String>emptyMap());
    }

    @Override
    public String doPost(String url, Map<String, String> parameters, Map<String, String> headers) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        if (!this.isNull(this._contextPath)) {
            url = this._contextPath + url;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Sending POST request to " + this._login + "@" + this._hostName + url);
            this.log("HTTP headers", headers);
            this.log("HTTP parameters", parameters);
        }
        HttpPost httpPost = new HttpPost(url);
        List<NameValuePair> nameValuePairs = this.toNameValuePairs(parameters);
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(nameValuePairs, _CHARSET);
        this.addHeaders((HttpMessage)httpPost, headers);
        httpPost.setEntity((HttpEntity)httpEntity);
        return this.execute((HttpRequestBase)httpPost);
    }

    @Override
    public String doPost(String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 0; i < parametersArray.length; i += 2) {
            parameters.put(parametersArray[i], parametersArray[i + 1]);
        }
        return this.doPost(url, parameters, Collections.<String, String>emptyMap());
    }

    @Override
    public String doPostAsJSON(String url, Object object) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        try {
            String json = this._objectMapper.writeValueAsString(object);
            return this.doPostAsJSON(url, json);
        }
        catch (IOException ioe) {
            throw this._getJSONWebServiceSerializeException(object);
        }
    }

    @Override
    public String doPostAsJSON(String url, String json) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doPostAsJSON(url, json, Collections.<String, String>emptyMap());
    }

    @Override
    public String doPostAsJSON(String url, String json, Map<String, String> headers) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        HttpPost httpPost = new HttpPost(url);
        this.addHeaders((HttpMessage)httpPost, headers);
        StringEntity stringEntity = new StringEntity(json, _CHARSET);
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return this.execute((HttpRequestBase)httpPost);
    }

    @Override
    public <T> T doPostToObject(Class<T> clazz, String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceSerializeException, JSONWebServiceTransportException {
        String json = this.doPost(url, parametersArray);
        if (json == null) {
            return null;
        }
        try {
            return (T)this._objectMapper.readValue(json, clazz);
        }
        catch (IOException ioe) {
            throw this._getJSONWebServiceSerializeException(json, clazz);
        }
    }

    @Override
    public String doPut(String url, Map<String, String> parameters) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        return this.doPut(url, parameters, Collections.<String, String>emptyMap());
    }

    @Override
    public String doPut(String url, Map<String, String> parameters, Map<String, String> headers) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        if (!this.isNull(this._contextPath)) {
            url = this._contextPath + url;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Sending PUT request to " + this._login + "@" + this._hostName + url);
            this.log("HTTP headers", headers);
            this.log("HTTP parameters", parameters);
        }
        HttpPut httpPut = new HttpPut(url);
        List<NameValuePair> nameValuePairs = this.toNameValuePairs(parameters);
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(nameValuePairs, _CHARSET);
        this.addHeaders((HttpMessage)httpPut, headers);
        httpPut.setEntity((HttpEntity)httpEntity);
        return this.execute((HttpRequestBase)httpPut);
    }

    @Override
    public String doPut(String url, String ... parametersArray) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 0; i < parametersArray.length; i += 2) {
            parameters.put(parametersArray[i], parametersArray[i + 1]);
        }
        return this.doPut(url, parameters, Collections.<String, String>emptyMap());
    }

    public Map<String, String> getHeaders() {
        return this._headers;
    }

    @Override
    public String getHostName() {
        return this._hostName;
    }

    @Override
    public int getHostPort() {
        return this._hostPort;
    }

    @Override
    public String getProtocol() {
        return this._protocol;
    }

    public String getProxyAuthType() {
        return this._proxyAuthType;
    }

    public String getProxyDomain() {
        return this._proxyDomain;
    }

    public String getProxyHostName() {
        return this._proxyHostName;
    }

    public int getProxyHostPort() {
        return this._proxyHostPort;
    }

    public String getProxyLogin() {
        return this._proxyLogin;
    }

    public String getProxyPassword() {
        return this._proxyPassword;
    }

    public String getProxyWorkstation() {
        return this._proxyWorkstation;
    }

    @Override
    public void registerModule(Module module) {
        this._objectMapper.registerModule(module);
    }

    @Override
    public void resetHttpClient() {
        this.destroy();
        try {
            this.afterPropertiesSet();
        }
        catch (IOReactorException iore) {
            _logger.error(iore.getMessage());
        }
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setHeaders(Map<String, String> headers) {
        this._headers = headers;
    }

    @Override
    public void setHostName(String hostName) {
        this._hostName = hostName;
    }

    @Override
    public void setHostPort(int hostPort) {
        this._hostPort = hostPort;
    }

    @Override
    public void setKeyStore(KeyStore keyStore) {
        this._keyStore = keyStore;
    }

    @Override
    public void setLogin(String login) {
        this._login = login;
    }

    @Override
    public void setMaxAttempts(int maxAttempts) {
        this._maxAttempts = maxAttempts;
    }

    @Override
    public void setOAuthAccessSecret(String oAuthAccessSecret) {
        this._oAuthAccessSecret = oAuthAccessSecret;
    }

    @Override
    public void setOAuthAccessToken(String oAuthAccessToken) {
        this._oAuthAccessToken = oAuthAccessToken;
    }

    @Override
    public void setOAuthConsumerKey(String oAuthConsumerKey) {
        this._oAuthConsumerKey = oAuthConsumerKey;
    }

    @Override
    public void setOAuthConsumerSecret(String oAuthConsumerSecret) {
        this._oAuthConsumerSecret = oAuthConsumerSecret;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setProxyAuthType(String proxyAuthType) {
        this._proxyAuthType = proxyAuthType;
    }

    public void setProxyDomain(String proxyDomain) {
        this._proxyDomain = proxyDomain;
    }

    public void setProxyHostName(String proxyHostName) {
        this._proxyHostName = proxyHostName;
    }

    public void setProxyHostPort(int proxyHostPort) {
        this._proxyHostPort = proxyHostPort;
    }

    public void setProxyLogin(String proxyLogin) {
        this._proxyLogin = proxyLogin;
    }

    public void setProxyPassword(String proxyPassword) {
        this._proxyPassword = proxyPassword;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this._proxyWorkstation = proxyWorkstation;
    }

    protected BaseJSONWebServiceClientImpl() {
        this._objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this._objectMapper.enableDefaultTypingAsProperty(ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "class");
    }

    protected void addHeaders(HttpMessage httpMessage, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpMessage.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this._headers.entrySet()) {
            httpMessage.addHeader(entry.getKey(), entry.getValue());
        }
    }

    protected String execute(HttpRequestBase httpRequestBase) throws JSONWebServiceInvocationException, JSONWebServiceTransportException {
        this.signRequest(httpRequestBase);
        HttpHost httpHost = new HttpHost(this._hostName, this._hostPort, this._protocol);
        try {
            if (this._asyncHttpClient == null) {
                this.afterPropertiesSet();
            }
            Future<HttpResponse> future = null;
            if (!this.isNull(this._login) && !this.isNull(this._password)) {
                HttpClientContext httpClientContext = HttpClientContext.create();
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme authScheme = null;
                authScheme = !this.isNull(this._proxyHostName) ? new BasicScheme(ChallengeState.PROXY) : new BasicScheme(ChallengeState.TARGET);
                authCache.put(httpHost, (AuthScheme)authScheme);
                httpClientContext.setAttribute("http.auth.auth-cache", (Object)authCache);
                future = this._asyncHttpClient.execute(httpHost, (HttpRequest)httpRequestBase, (HttpContext)httpClientContext);
            } else {
                future = this._asyncHttpClient.execute(httpHost, (HttpRequest)httpRequestBase);
            }
            HttpResponse httpResponse = future.get();
            StatusLine statusLine = httpResponse.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (_logger.isTraceEnabled()) {
                _logger.trace("Server returned status " + statusCode);
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            if (statusCode == 204 || (httpEntity == null || httpEntity.getContentLength() == 0L) && this._isStatus2XX(statusCode)) {
                String string = null;
                return string;
            }
            String content = EntityUtils.toString((HttpEntity)httpEntity, (Charset)_CHARSET);
            if (httpEntity.getContentType() != null && this._isApplicationJSONContentType(httpEntity)) {
                content = this.updateJSON(content);
            }
            if (this._isStatus2XX(statusCode)) {
                String string = content;
                return string;
            }
            try {
                if (statusCode == 400 || statusCode == 403 || statusCode == 405 || statusCode == 406 || statusCode == 404) {
                    throw new JSONWebServiceInvocationException(content, statusCode);
                }
                if (statusCode == 401) {
                    throw new JSONWebServiceTransportException.AuthenticationFailure("Not authorized to access JSON web service " + content);
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Server returned status ");
                sb.append(statusCode);
                sb.append(" and content ");
                sb.append(content);
                throw new JSONWebServiceTransportException.CommunicationFailure(sb.toString(), statusCode);
            }
            catch (ExecutionException ee) {
                throw new JSONWebServiceTransportException.CommunicationFailure("Unable to transmit request to " + this._hostName, ee);
            }
            catch (InterruptedException ie) {
                throw new JSONWebServiceTransportException.CommunicationFailure("Unable to transmit request to " + this._hostName, ie);
            }
            catch (IOException ioe) {
                throw new JSONWebServiceTransportException.CommunicationFailure("Unable to transmit request to " + this._hostName, ioe);
            }
        }
        finally {
            httpRequestBase.releaseConnection();
        }
    }

    protected String getExceptionMessage(String json) {
        int exceptionMessageStart = json.indexOf("exception\":\"") + 12;
        int exceptionMessageEnd = json.indexOf("\"", exceptionMessageStart);
        return json.substring(exceptionMessageStart, exceptionMessageEnd);
    }

    protected PoolingNHttpClientConnectionManager getPoolingNHttpClientConnectionManager() throws IOReactorException {
        PoolingNHttpClientConnectionManager poolingNHttpClientConnectionManager = null;
        DefaultConnectingIOReactor connectingIOReactor = new DefaultConnectingIOReactor();
        poolingNHttpClientConnectionManager = this._keyStore != null ? new PoolingNHttpClientConnectionManager((ConnectingIOReactor)connectingIOReactor, null, this.getSchemeIOSessionStrategyRegistry(), null, null, 60000L, TimeUnit.MILLISECONDS) : new PoolingNHttpClientConnectionManager((ConnectingIOReactor)connectingIOReactor);
        poolingNHttpClientConnectionManager.setMaxTotal(20);
        return poolingNHttpClientConnectionManager;
    }

    protected Registry<SchemeIOSessionStrategy> getSchemeIOSessionStrategyRegistry() {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", (Object)NoopIOSessionStrategy.INSTANCE);
        registryBuilder.register("https", (Object)this.getSSLIOSessionStrategy());
        return registryBuilder.build();
    }

    protected SSLIOSessionStrategy getSSLIOSessionStrategy() {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        SSLContext sslContext = null;
        try {
            sslContextBuilder.loadTrustMaterial(this._keyStore, (TrustStrategy)new TrustSelfSignedStrategy());
            sslContext = sslContextBuilder.build();
            sslContext.init(null, new TrustManager[]{new X509TrustManagerImpl()}, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new SSLIOSessionStrategy(sslContext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    protected int getStatus(String json) {
        Matcher statusMatcher = this._statusPattern.matcher(json);
        if (!statusMatcher.find()) {
            return 0;
        }
        return Integer.parseInt(statusMatcher.group(1));
    }

    protected boolean isNull(String s) {
        return s == null || s.equals("");
    }

    protected void log(String message, Map<String, String> map) {
        if (!_logger.isDebugEnabled() || map.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(map.size() * 4 + 2);
        sb.append(message);
        sb.append(":");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                key = "-" + key;
                value = "";
            }
            sb.append("\n");
            sb.append(key);
            sb.append("=");
            sb.append(value);
        }
        _logger.debug(sb.toString());
    }

    protected void setProxyHost(HttpAsyncClientBuilder httpClientBuilder) {
        if (this._proxyHostName == null || this._proxyHostName.equals("")) {
            return;
        }
        httpClientBuilder.setProxy(new HttpHost(this._proxyHostName, this._proxyHostPort));
        httpClientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
    }

    protected abstract void signRequest(HttpRequestBase var1) throws JSONWebServiceTransportException.SigningFailure;

    protected List<NameValuePair> toNameValuePairs(Map<String, String> parameters) {
        LinkedList<NameValuePair> nameValuePairs = new LinkedList<NameValuePair>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                key = "-" + key;
                value = "";
            }
            BasicNameValuePair nameValuePair = new BasicNameValuePair(key, value);
            nameValuePairs.add((NameValuePair)nameValuePair);
        }
        return nameValuePairs;
    }

    protected String updateJSON(String json) throws JSONWebServiceInvocationException {
        if (json == null || json.equals("") || json.equals("{}") || json.equals("[]")) {
            return null;
        }
        Matcher matcher = this._errorMessagePattern.matcher(json);
        if (matcher.find()) {
            throw new JSONWebServiceInvocationException(json, Integer.parseInt(matcher.group(2)));
        }
        if (json.contains("exception\":\"")) {
            throw new JSONWebServiceInvocationException(this.getExceptionMessage(json), this.getStatus(json));
        }
        return json;
    }

    private CredentialsProvider _getCredentialsProvider() {
        StringBuilder sb;
        if ((this.isNull(this._login) || this.isNull(this._password)) && (this.isNull(this._proxyLogin) || this.isNull(this._proxyPassword))) {
            return null;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (!this.isNull(this._login)) {
            credentialsProvider.setCredentials(new AuthScope(this._hostName, this._hostPort), (Credentials)new UsernamePasswordCredentials(this._login, this._password));
            if (_logger.isDebugEnabled()) {
                sb = new StringBuilder();
                sb.append("Basic credentials are used for ");
                sb.append(this._hostName);
                sb.append(":");
                sb.append(this._hostPort);
                _logger.debug(sb.toString());
            }
        }
        if (this.isNull(this._proxyLogin)) {
            return credentialsProvider;
        }
        credentialsProvider.setCredentials(new AuthScope(this._proxyHostName, this._proxyHostPort), this._getProxyCredentials());
        if (_logger.isDebugEnabled()) {
            sb = new StringBuilder();
            sb.append("Proxy credentials are used for ");
            sb.append(this._hostName);
            sb.append(":");
            sb.append(this._hostPort);
            _logger.debug(sb.toString());
        }
        return credentialsProvider;
    }

    private JSONWebServiceSerializeException _getJSONWebServiceSerializeException(Object object) {
        StringBuffer sb = new StringBuffer();
        sb.append("Unable to serialize object with type ");
        sb.append(object.getClass());
        return new JSONWebServiceSerializeException(sb.toString());
    }

    private <T> JSONWebServiceSerializeException _getJSONWebServiceSerializeException(String json, Class<T> clazz) {
        StringBuffer sb = new StringBuffer();
        sb.append("Unable to deserialize ");
        sb.append(json);
        sb.append(" into object with type ");
        sb.append(clazz.getName());
        return new JSONWebServiceSerializeException(sb.toString());
    }

    private Credentials _getProxyCredentials() {
        if ("ntlm".equalsIgnoreCase(this._proxyAuthType)) {
            return new NTCredentials(this._proxyLogin, this._proxyPassword, this._proxyWorkstation, this._proxyDomain);
        }
        return new UsernamePasswordCredentials(this._proxyLogin, this._proxyPassword);
    }

    private boolean _isApplicationJSONContentType(HttpEntity httpEntity) {
        Header contentTypeHeader = httpEntity.getContentType();
        String contentTypeHeaderValue = contentTypeHeader.getValue();
        return contentTypeHeaderValue.contains("application/json");
    }

    private boolean _isStatus2XX(int statusCode) {
        return statusCode == 200 || statusCode == 201 || statusCode == 202 || statusCode == 203 || statusCode == 204;
    }
}

