/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.json.web.service.client.internal;

import com.liferay.petra.json.web.service.client.JSONWebServiceTransportException;
import com.liferay.petra.json.web.service.client.internal.JSONWebServiceClientImpl;
import java.net.URI;
import java.util.Map;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.exception.OAuthException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.nio.reactor.IOReactorException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(factory="OAuthJSONWebServiceClient", service={})
public class OAuthJSONWebServiceClientImpl
extends JSONWebServiceClientImpl {
    private String _oAuthAccessSecret;
    private String _oAuthAccessToken;
    private String _oAuthConsumerKey;
    private String _oAuthConsumerSecret;

    @Override
    public void setOAuthAccessSecret(String oAuthAccessSecret) {
        this._oAuthAccessSecret = oAuthAccessSecret;
    }

    @Override
    public void setOAuthAccessToken(String oAuthAccessToken) {
        this._oAuthAccessToken = oAuthAccessToken;
    }

    @Override
    public void setOAuthConsumerKey(String oAuthConsumerKey) {
        this._oAuthConsumerKey = oAuthConsumerKey;
    }

    @Override
    public void setOAuthConsumerSecret(String oAuthConsumerSecret) {
        this._oAuthConsumerSecret = oAuthConsumerSecret;
    }

    @Override
    @Activate
    protected void activate(Map<String, Object> properties) throws IOReactorException {
        this.setOAuthConsumerKey(this.getString("oAuthConsumerKey", properties));
        this.setOAuthConsumerSecret(this.getString("oAuthConsumerSecret", properties));
        super.activate(properties);
    }

    protected String buildURL(String hostName, int port, String protocol, String uri) {
        StringBuilder sb = new StringBuilder();
        sb.append(protocol);
        sb.append(":");
        sb.append("//");
        sb.append(hostName);
        if (protocol.equals("http") && port != 80 || protocol.equals("https") && port != 443) {
            sb.append(":");
            sb.append(port);
        }
        sb.append(uri);
        return sb.toString();
    }

    protected OAuthConsumer getOAuthConsumer(String accessToken, String accessSecret) {
        CommonsHttpOAuthConsumer oAuthConsumer = new CommonsHttpOAuthConsumer(this._oAuthConsumerKey, this._oAuthConsumerSecret);
        oAuthConsumer.setTokenWithSecret(accessToken, accessSecret);
        return oAuthConsumer;
    }

    @Override
    protected void signRequest(HttpRequestBase httpRequestBase) throws JSONWebServiceTransportException.SigningFailure {
        if (this._oAuthAccessToken == null && this._oAuthAccessSecret == null) {
            throw new JSONWebServiceTransportException.SigningFailure("OAuth credentials are not set", -1);
        }
        OAuthConsumer oAuthConsumer = this.getOAuthConsumer(this._oAuthAccessToken, this._oAuthAccessSecret);
        String requestURL = this.buildURL(this.getHostName(), this.getHostPort(), this.getProtocol(), String.valueOf(httpRequestBase.getURI()));
        httpRequestBase.setURI(URI.create(requestURL));
        try {
            oAuthConsumer.sign((Object)httpRequestBase);
        }
        catch (OAuthException oAuthException) {
            throw new JSONWebServiceTransportException.SigningFailure("Unable to sign HTTP request", oAuthException);
        }
    }
}

