/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io.unsync;

import com.liferay.petra.io.unsync.BoundaryCheckerUtil;
import com.liferay.petra.nio.CharsetEncoderUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class UnsyncCharArrayWriter
extends Writer {
    private char[] _buffer;
    private int _index;

    public UnsyncCharArrayWriter() {
        this(32);
    }

    public UnsyncCharArrayWriter(int initialSize) {
        this._buffer = new char[initialSize];
    }

    @Override
    public Writer append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) {
        String string = null;
        string = charSequence == null ? "null" : charSequence.toString();
        this.write(string, 0, string.length());
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int start, int end) {
        String string = null;
        if (charSequence == null) {
            string = "null";
        } else {
            charSequence = charSequence.subSequence(start, end);
            string = charSequence.toString();
        }
        this.write(string, 0, string.length());
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public void reset() {
        this._index = 0;
    }

    public int size() {
        return this._index;
    }

    public CharBuffer toCharBuffer() {
        return CharBuffer.wrap(this._buffer, 0, this._index);
    }

    public String toString() {
        return new String(this._buffer, 0, this._index);
    }

    @Override
    public void write(char[] chars) {
        this.write(chars, 0, chars.length);
    }

    @Override
    public void write(char[] chars, int offset, int length) {
        BoundaryCheckerUtil.check(chars.length, offset, length);
        if (length == 0) {
            return;
        }
        int newIndex = this._index + length;
        if (newIndex > this._buffer.length) {
            int newBufferSize = Math.max(this._buffer.length << 1, newIndex);
            char[] newBuffer = new char[newBufferSize];
            System.arraycopy(this._buffer, 0, newBuffer, 0, this._index);
            this._buffer = newBuffer;
        }
        System.arraycopy(chars, offset, this._buffer, this._index, length);
        this._index = newIndex;
    }

    @Override
    public void write(int c) {
        int newIndex = this._index + 1;
        if (newIndex > this._buffer.length) {
            int newBufferSize = Math.max(this._buffer.length << 1, newIndex);
            char[] newBuffer = new char[newBufferSize];
            System.arraycopy(this._buffer, 0, newBuffer, 0, this._buffer.length);
            this._buffer = newBuffer;
        }
        this._buffer[this._index] = (char)c;
        this._index = newIndex;
    }

    @Override
    public void write(String string) {
        this.write(string, 0, string.length());
    }

    @Override
    public void write(String string, int offset, int length) {
        BoundaryCheckerUtil.check(string.length(), offset, length);
        if (length == 0) {
            return;
        }
        int newIndex = this._index + length;
        if (newIndex > this._buffer.length) {
            int newBufferSize = Math.max(this._buffer.length << 1, newIndex);
            char[] newBuffer = new char[newBufferSize];
            System.arraycopy(this._buffer, 0, newBuffer, 0, this._index);
            this._buffer = newBuffer;
        }
        string.getChars(offset, offset + length, this._buffer, this._index);
        this._index = newIndex;
    }

    public int writeTo(CharBuffer charBuffer) {
        int length = charBuffer.remaining();
        if (length > this._index) {
            length = this._index;
        }
        if (length == 0) {
            return 0;
        }
        charBuffer.put(this._buffer, 0, length);
        return length;
    }

    public int writeTo(OutputStream outputStream, String charsetName) throws IOException {
        ByteBuffer byteBuffer = CharsetEncoderUtil.encode((String)charsetName, (CharBuffer)CharBuffer.wrap(this._buffer, 0, this._index));
        int length = byteBuffer.limit();
        outputStream.write(byteBuffer.array(), 0, length);
        return length;
    }

    public int writeTo(Writer writer) throws IOException {
        writer.write(this._buffer, 0, this._index);
        return this._index;
    }
}

