/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io.unsync;

import java.io.IOException;
import java.io.OutputStream;

public class UnsyncFilterOutputStream
extends OutputStream {
    protected OutputStream outputStream;

    public UnsyncFilterOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void close() throws IOException {
        try (OutputStream os = this.outputStream;){
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.outputStream.write(bytes, offset, length);
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }
}

