/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io;

import com.liferay.petra.io.AnnotatedObjectOutputStream;
import com.liferay.petra.io.BigEndianCodec;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.ClassLoaderPool;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Serializer {
    private static final int _THREADLOCAL_BUFFER_COUNT_LIMIT;
    private static final int _THREADLOCAL_BUFFER_COUNT_MIN = 8;
    private static final int _THREADLOCAL_BUFFER_SIZE_LIMIT;
    private static final int _THREADLOCAL_BUFFER_SIZE_MIN = 16384;
    private static final ThreadLocal<Reference<BufferQueue>> _bufferQueueThreadLocal;
    private byte[] _buffer;
    private int _index;

    public Serializer() {
        BufferQueue bufferQueue = this._getBufferQueue();
        this._buffer = bufferQueue.dequeue();
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(Arrays.copyOf(this._buffer, this._index));
        if (this._buffer.length <= _THREADLOCAL_BUFFER_SIZE_LIMIT) {
            BufferQueue bufferQueue = this._getBufferQueue();
            bufferQueue.enqueue(this._buffer);
        }
        this._buffer = null;
        return byteBuffer;
    }

    public void writeBoolean(boolean b) {
        BigEndianCodec.putBoolean(this._getBuffer(1), this._index++, b);
    }

    public void writeByte(byte b) {
        this._getBuffer((int)1)[this._index++] = b;
    }

    public void writeChar(char c) {
        BigEndianCodec.putChar(this._getBuffer(2), this._index, c);
        this._index += 2;
    }

    public void writeDouble(double d) {
        BigEndianCodec.putDouble(this._getBuffer(8), this._index, d);
        this._index += 8;
    }

    public void writeFloat(float f) {
        BigEndianCodec.putFloat(this._getBuffer(4), this._index, f);
        this._index += 4;
    }

    public void writeInt(int i) {
        BigEndianCodec.putInt(this._getBuffer(4), this._index, i);
        this._index += 4;
    }

    public void writeLong(long l) {
        BigEndianCodec.putLong(this._getBuffer(8), this._index, l);
        this._index += 8;
    }

    public void writeObject(Serializable serializable) {
        if (serializable == null) {
            this.writeByte((byte)8);
            return;
        }
        if (serializable instanceof Long) {
            this.writeByte((byte)7);
            this.writeLong((Long)serializable);
            return;
        }
        if (serializable instanceof String) {
            this.writeByte((byte)11);
            this.writeString((String)((Object)serializable));
            return;
        }
        if (serializable instanceof Integer) {
            this.writeByte((byte)6);
            this.writeInt((Integer)serializable);
            return;
        }
        if (serializable instanceof Boolean) {
            this.writeByte((byte)0);
            this.writeBoolean((Boolean)serializable);
            return;
        }
        if (serializable instanceof Class) {
            Class clazz = (Class)serializable;
            String contextName = ClassLoaderPool.getContextName((ClassLoader)clazz.getClassLoader());
            this.writeByte((byte)3);
            this.writeString(contextName);
            this.writeString(clazz.getName());
            return;
        }
        if (serializable instanceof Short) {
            this.writeByte((byte)10);
            this.writeShort((Short)serializable);
            return;
        }
        if (serializable instanceof Character) {
            this.writeByte((byte)2);
            this.writeChar(((Character)serializable).charValue());
            return;
        }
        if (serializable instanceof Byte) {
            this.writeByte((byte)1);
            this.writeByte((Byte)serializable);
            return;
        }
        if (serializable instanceof Double) {
            this.writeByte((byte)4);
            this.writeDouble((Double)serializable);
            return;
        }
        if (serializable instanceof Float) {
            this.writeByte((byte)5);
            this.writeFloat(((Float)serializable).floatValue());
            return;
        }
        this.writeByte((byte)9);
        try {
            AnnotatedObjectOutputStream objectOutputStream = new AnnotatedObjectOutputStream(new BufferOutputStream());
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to write ordinary serializable object " + serializable, ioException);
        }
    }

    public void writeShort(short s) {
        BigEndianCodec.putShort(this._getBuffer(2), this._index, s);
        this._index += 2;
    }

    public void writeString(String s) {
        int i;
        int length = s.length();
        boolean asciiCode = true;
        for (int i2 = 0; i2 < length; ++i2) {
            char c = s.charAt(i2);
            if (c != '\u0000' && c <= '\u007f') continue;
            asciiCode = false;
            break;
        }
        if (asciiCode) {
            byte[] buffer = this._getBuffer(length + 5);
            BigEndianCodec.putBoolean(buffer, this._index++, asciiCode);
            BigEndianCodec.putInt(buffer, this._index, length);
            this._index += 4;
            for (i = 0; i < length; ++i) {
                char c = s.charAt(i);
                buffer[this._index++] = (byte)c;
            }
        } else {
            byte[] buffer = this._getBuffer(length * 2 + 5);
            BigEndianCodec.putBoolean(buffer, this._index++, asciiCode);
            BigEndianCodec.putInt(buffer, this._index, length);
            this._index += 4;
            for (i = 0; i < length; ++i) {
                char c = s.charAt(i);
                BigEndianCodec.putChar(buffer, this._index, c);
                this._index += 2;
            }
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this._buffer, 0, this._index);
        if (this._buffer.length <= _THREADLOCAL_BUFFER_SIZE_LIMIT) {
            BufferQueue bufferQueue = this._getBufferQueue();
            bufferQueue.enqueue(this._buffer);
        }
        this._buffer = null;
    }

    private byte[] _getBuffer(int ensureExtraSpace) {
        int minSize = this._index + ensureExtraSpace;
        if (minSize < 0) {
            throw new OutOfMemoryError();
        }
        int oldSize = this._buffer.length;
        if (minSize > oldSize) {
            int newSize = oldSize << 1;
            if (newSize < minSize) {
                newSize = minSize;
            }
            this._buffer = Arrays.copyOf(this._buffer, newSize);
        }
        return this._buffer;
    }

    private BufferQueue _getBufferQueue() {
        Reference<BufferQueue> reference = _bufferQueueThreadLocal.get();
        BufferQueue bufferQueue = null;
        if (reference != null) {
            bufferQueue = reference.get();
        }
        if (bufferQueue == null) {
            bufferQueue = new BufferQueue();
            _bufferQueueThreadLocal.set(new SoftReference<BufferQueue>(bufferQueue));
        }
        return bufferQueue;
    }

    static {
        _bufferQueueThreadLocal = new CentralizedThreadLocal(false);
        int threadLocalBufferCountLimit = Integer.getInteger(Serializer.class.getName() + ".thread.local.buffer.count.limit", 0);
        if (threadLocalBufferCountLimit < 8) {
            threadLocalBufferCountLimit = 8;
        }
        _THREADLOCAL_BUFFER_COUNT_LIMIT = threadLocalBufferCountLimit;
        int threadLocalBufferSizeLimit = Integer.getInteger(Serializer.class.getName() + ".thread.local.buffer.size.limit", 0);
        if (threadLocalBufferSizeLimit < 16384) {
            threadLocalBufferSizeLimit = 16384;
        }
        _THREADLOCAL_BUFFER_SIZE_LIMIT = threadLocalBufferSizeLimit;
    }

    private class BufferOutputStream
    extends OutputStream {
        private BufferOutputStream() {
        }

        @Override
        public void write(byte[] bytes) {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int offset, int length) {
            byte[] buffer = Serializer.this._getBuffer(length);
            System.arraycopy(bytes, offset, buffer, Serializer.this._index, length);
            Serializer.this._index = Serializer.this._index + length;
        }

        @Override
        public void write(int b) {
            ((Serializer)Serializer.this)._getBuffer((int)1)[((Serializer)Serializer.this)._index++] = (byte)b;
        }
    }

    private static class BufferQueue {
        private int _count;
        private BufferNode _headBufferNode;

        private BufferQueue() {
        }

        public byte[] dequeue() {
            if (this._headBufferNode == null) {
                return new byte[16384];
            }
            BufferNode bufferNode = this._headBufferNode;
            this._headBufferNode = this._headBufferNode._next;
            bufferNode._next = null;
            return bufferNode._buffer;
        }

        public void enqueue(byte[] buffer) {
            BufferNode bufferNode = new BufferNode(buffer);
            if (this._headBufferNode == null) {
                this._headBufferNode = bufferNode;
                this._count = 1;
                return;
            }
            BufferNode previousBufferNode = null;
            BufferNode currentBufferNode = this._headBufferNode;
            while (currentBufferNode != null && currentBufferNode._buffer.length > bufferNode._buffer.length) {
                previousBufferNode = currentBufferNode;
                currentBufferNode = currentBufferNode._next;
            }
            if (previousBufferNode == null) {
                bufferNode._next = this._headBufferNode;
                this._headBufferNode = bufferNode;
            } else {
                bufferNode._next = currentBufferNode;
                previousBufferNode._next = bufferNode;
            }
            if (++this._count > _THREADLOCAL_BUFFER_COUNT_LIMIT) {
                if (previousBufferNode == null) {
                    previousBufferNode = this._headBufferNode;
                }
                currentBufferNode = previousBufferNode._next;
                while (currentBufferNode._next != null) {
                    previousBufferNode = currentBufferNode;
                    currentBufferNode = currentBufferNode._next;
                }
                previousBufferNode._next = null;
                BufferNode.access$302(currentBufferNode, null);
                currentBufferNode._next = null;
            }
        }
    }

    private static class BufferNode {
        private byte[] _buffer;
        private BufferNode _next;

        private BufferNode(byte[] buffer) {
            this._buffer = buffer;
        }

        static /* synthetic */ byte[] access$302(BufferNode x0, byte[] x1) {
            x0._buffer = x1;
            return x1;
        }
    }
}

