/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class StreamUtil {
    public static final int BUFFER_SIZE = Integer.getInteger(StreamUtil.class.getName() + ".buffer.size", 8192);
    public static final boolean FORCE_TIO = Boolean.getBoolean(StreamUtil.class.getName() + ".force.tio");

    public static void cleanUp(Closeable ... closeables) throws IOException {
        IOException ioException = null;
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException ioe) {
                if (ioException == null) {
                    ioException = ioe;
                    continue;
                }
                ioException.addSuppressed(ioe);
            }
        }
        if (ioException == null) {
            return;
        }
        throw ioException;
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, BUFFER_SIZE, true);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, boolean cleanUp) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, BUFFER_SIZE, cleanUp);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, bufferSize, true);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, int bufferSize, boolean cleanUp) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, bufferSize, cleanUp, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transfer(InputStream inputStream, OutputStream outputStream, int bufferSize, boolean cleanUp, long length) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("Input stream is null");
        }
        if (outputStream == null) {
            throw new NullPointerException("Output stream is null");
        }
        if (bufferSize <= 0) {
            bufferSize = BUFFER_SIZE;
        }
        try {
            if (!FORCE_TIO && inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                FileInputStream fileInputStream = (FileInputStream)inputStream;
                FileOutputStream fileOutputStream = (FileOutputStream)outputStream;
                StreamUtil._transferFileChannel(fileInputStream.getChannel(), fileOutputStream.getChannel(), length);
            } else {
                StreamUtil._transferByteArray(inputStream, outputStream, bufferSize, length);
            }
            if (!cleanUp) return;
        }
        catch (Throwable throwable) {
            if (!cleanUp) throw throwable;
            StreamUtil.cleanUp(inputStream, outputStream);
            throw throwable;
        }
        StreamUtil.cleanUp(inputStream, outputStream);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, long length) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, BUFFER_SIZE, true, length);
    }

    private static void _transferByteArray(InputStream inputStream, OutputStream outputStream, int bufferSize, long length) throws IOException {
        byte[] bytes = new byte[bufferSize];
        if (length > 0L) {
            int readBytes;
            for (long remainingLength = length; remainingLength > 0L && (readBytes = inputStream.read(bytes, 0, (int)Math.min(remainingLength, (long)bufferSize))) != -1; remainingLength -= (long)readBytes) {
                outputStream.write(bytes, 0, readBytes);
            }
        } else {
            int readBytes = -1;
            while ((readBytes = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, readBytes);
            }
        }
    }

    private static void _transferFileChannel(FileChannel inputFileChannel, FileChannel outputFileChannel, long length) throws IOException {
        if (length <= 0L) {
            length = inputFileChannel.size() - inputFileChannel.position();
        }
        for (long count = 0L; count < length; count += inputFileChannel.transferTo(inputFileChannel.position() + count, length - count, outputFileChannel)) {
        }
    }
}

