/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io.unsync;

import java.io.InputStream;

public class UnsyncByteArrayInputStream
extends InputStream {
    private final byte[] _buffer;
    private final int _capacity;
    private int _index;
    private int _markIndex;

    public UnsyncByteArrayInputStream(byte[] buffer) {
        this._buffer = buffer;
        this._index = 0;
        this._capacity = buffer.length;
    }

    public UnsyncByteArrayInputStream(byte[] buffer, int offset, int length) {
        this._buffer = buffer;
        this._index = offset;
        this._capacity = Math.min(buffer.length, offset + length);
        this._markIndex = offset;
    }

    @Override
    public int available() {
        return this._capacity - this._index;
    }

    @Override
    public void mark(int readAheadLimit) {
        this._markIndex = this._index;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        if (this._index < this._capacity) {
            return this._buffer[this._index++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes) {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException("{length=" + length + "}");
        }
        if (length == 0) {
            return 0;
        }
        if (this._index >= this._capacity) {
            return -1;
        }
        int read = length;
        if (this._index + read > this._capacity) {
            read = this._capacity - this._index;
        }
        System.arraycopy(this._buffer, this._index, bytes, offset, read);
        this._index += read;
        return read;
    }

    @Override
    public void reset() {
        this._index = this._markIndex;
    }

    @Override
    public long skip(long skip) {
        if (skip < 0L) {
            return 0L;
        }
        if (skip + (long)this._index > (long)this._capacity) {
            skip = this._capacity - this._index;
        }
        this._index = (int)((long)this._index + skip);
        return skip;
    }
}

