/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.function.transform;

import com.liferay.petra.function.UnsafeFunction;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TransformUtil {
    public static <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransform(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        try {
            return TransformUtil.unsafeTransform(array, unsafeFunction, clazz);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        try {
            return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        try {
            return TransformUtil.unsafeTransformToList(array, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        if (collection == null) {
            return new ArrayList();
        }
        ArrayList<R> list = new ArrayList<R>(collection.size());
        for (T item : collection) {
            R newItem = unsafeFunction.apply(item);
            if (newItem == null) continue;
            list.add(newItem);
        }
        return list;
    }

    public static <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        List<R> list = TransformUtil.unsafeTransformToList(array, unsafeFunction);
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        List<R> list = TransformUtil.unsafeTransform(collection, unsafeFunction);
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<R> list = new ArrayList<R>(array.length);
        for (T item : array) {
            R newItem = unsafeFunction.apply(item);
            if (newItem == null) continue;
            list.add(newItem);
        }
        return list;
    }
}

