/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.function;

import java.util.Collection;

@FunctionalInterface
public interface UnsafeConsumer<E, T extends Throwable> {
    public static <E> void accept(Collection<E> collection, UnsafeConsumer<E, ? super Throwable> unsafeConsumer) throws Throwable {
        UnsafeConsumer.accept(collection, unsafeConsumer, Throwable.class);
    }

    public static <E, T extends Throwable> void accept(Collection<E> collection, UnsafeConsumer<E, T> unsafeConsumer, Class<? extends T> throwableClass) throws T {
        Throwable throwable = null;
        for (E e : collection) {
            try {
                unsafeConsumer.accept(e);
            }
            catch (Throwable t) {
                if (!throwableClass.isInstance(t)) {
                    if (throwable != null) {
                        t.addSuppressed(throwable);
                    }
                    throw t;
                }
                if (throwable == null) {
                    throwable = (Throwable)throwableClass.cast(t);
                    continue;
                }
                throwable.addSuppressed(t);
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    public void accept(E var1) throws T;
}

