/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.content;

import com.liferay.petra.string.StringUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContentUtil {
    private static final Logger _logger = Logger.getLogger(ContentUtil.class.getName());
    private static final ContentUtil _contentUtil = new ContentUtil();
    private final Map<String, String> _contentPool = new HashMap<String, String>();

    public static String get(ClassLoader classLoader, String location) {
        return _contentUtil._get(classLoader, location, false);
    }

    public static String get(ClassLoader classLoader, String location, boolean all) {
        return _contentUtil._get(classLoader, location, all);
    }

    private ContentUtil() {
    }

    private String _get(ClassLoader classLoader, String location, boolean all) {
        String content = this._contentPool.get(location);
        if (content == null) {
            try {
                content = StringUtil.read((ClassLoader)classLoader, (String)location, (boolean)all);
                this._put(location, content);
            }
            catch (IOException ioException) {
                _logger.log(Level.SEVERE, ioException.getMessage(), ioException);
            }
        }
        return content;
    }

    private void _put(String location, String content) {
        this._contentPool.put(location, content);
    }
}

