/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.password.policies.admin.web.internal.search;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.PasswordPolicyRel;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PasswordPolicyRelLocalServiceUtil;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class AddOrganizationPasswordPolicyChecker
extends EmptyOnClickRowChecker {
    private static final Log _log = LogFactoryUtil.getLog(AddOrganizationPasswordPolicyChecker.class);
    private final PasswordPolicy _passwordPolicy;

    public AddOrganizationPasswordPolicyChecker(RenderResponse renderResponse, PasswordPolicy passwordPolicy) {
        super((PortletResponse)renderResponse);
        this._passwordPolicy = passwordPolicy;
    }

    public boolean isChecked(Object obj) {
        Organization organization = (Organization)obj;
        try {
            return OrganizationLocalServiceUtil.hasPasswordPolicyOrganization((long)this._passwordPolicy.getPasswordPolicyId(), (long)organization.getOrganizationId());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isDisabled(Object obj) {
        Organization organization = (Organization)obj;
        if (this.isChecked(obj)) {
            return true;
        }
        try {
            PasswordPolicyRel passwordPolicyRel = PasswordPolicyRelLocalServiceUtil.fetchPasswordPolicyRel((String)Organization.class.getName(), (long)organization.getOrganizationId());
            if (passwordPolicyRel != null && passwordPolicyRel.getPasswordPolicyId() != this._passwordPolicy.getPasswordPolicyId()) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return false;
    }
}

