/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.password.policies.admin.web.internal.portlet;

import com.liferay.portal.kernel.exception.DuplicatePasswordPolicyException;
import com.liferay.portal.kernel.exception.NoSuchPasswordPolicyException;
import com.liferay.portal.kernel.exception.PasswordPolicyNameException;
import com.liferay.portal.kernel.exception.RequiredPasswordPolicyException;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.PasswordPolicyService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.css-class-wrapper=portlet-users-admin", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.icon=/icons/password_policies_admin.png", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.use-default-template=true", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_password_policies_admin_web_portlet_PasswordPoliciesAdminPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class PasswordPoliciesAdminPortlet
extends MVCPortlet {
    @Reference
    private Http _http;
    private OrganizationService _organizationService;
    private PasswordPolicyService _passwordPolicyService;
    private UserService _userService;

    public void deletePasswordPolicies(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] passwordPolicyIds;
        for (long passwordPolicyId : passwordPolicyIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"passwordPolicyIds"), (long)0L)) {
            this._passwordPolicyService.deletePasswordPolicy(passwordPolicyId);
        }
    }

    public void deletePasswordPolicy(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long passwordPolicyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"passwordPolicyId");
        this._passwordPolicyService.deletePasswordPolicy(passwordPolicyId);
    }

    public void editPasswordPolicy(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long passwordPolicyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"passwordPolicyId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        boolean changeable = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"changeable");
        boolean changeRequired = false;
        long minAge = 0L;
        if (changeable) {
            changeRequired = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"changeRequired");
            minAge = ParamUtil.getLong((PortletRequest)actionRequest, (String)"minAge");
        }
        boolean checkSyntax = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"checkSyntax");
        boolean allowDictionaryWords = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowDictionaryWords");
        int minAlphanumeric = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minAlphanumeric");
        int minLength = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minLength");
        int minLowerCase = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minLowerCase");
        int minNumbers = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minNumbers");
        int minSymbols = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minSymbols");
        int minUpperCase = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minUpperCase");
        String regex = ParamUtil.getString((PortletRequest)actionRequest, (String)"regex");
        boolean history = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"history");
        int historyCount = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"historyCount");
        boolean expireable = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"expireable");
        long maxAge = ParamUtil.getLong((PortletRequest)actionRequest, (String)"maxAge");
        long warningTime = ParamUtil.getLong((PortletRequest)actionRequest, (String)"warningTime");
        int graceLimit = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"graceLimit");
        boolean lockout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"lockout");
        int maxFailure = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"maxFailure");
        long lockoutDuration = ParamUtil.getLong((PortletRequest)actionRequest, (String)"lockoutDuration");
        long resetFailureCount = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resetFailureCount");
        long resetTicketMaxAge = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resetTicketMaxAge");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)PasswordPolicy.class.getName(), (PortletRequest)actionRequest);
        if (passwordPolicyId <= 0L) {
            PasswordPolicy passwordPolicy = this._passwordPolicyService.addPasswordPolicy(name, description, changeable, changeRequired, minAge, checkSyntax, allowDictionaryWords, minAlphanumeric, minLength, minLowerCase, minNumbers, minSymbols, minUpperCase, regex, history, historyCount, expireable, maxAge, warningTime, graceLimit, lockout, maxFailure, lockoutDuration, resetFailureCount, resetTicketMaxAge, serviceContext);
            passwordPolicyId = passwordPolicy.getPasswordPolicyId();
        } else {
            this._passwordPolicyService.updatePasswordPolicy(passwordPolicyId, name, description, changeable, changeRequired, minAge, checkSyntax, allowDictionaryWords, minAlphanumeric, minLength, minLowerCase, minNumbers, minSymbols, minUpperCase, regex, history, historyCount, expireable, maxAge, warningTime, graceLimit, lockout, maxFailure, lockoutDuration, resetFailureCount, resetTicketMaxAge, serviceContext);
        }
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        if (Validator.isNotNull((String)redirect)) {
            redirect = this._http.setParameter(redirect, actionResponse.getNamespace() + "passwordPolicyId", passwordPolicyId);
            actionRequest.setAttribute("REDIRECT", (Object)redirect);
        }
    }

    public void editPasswordPolicyAssignments(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long passwordPolicyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"passwordPolicyId");
        long[] addUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addUserIds"), (long)0L);
        long[] removeUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeUserIds"), (long)0L);
        long[] addOrganizationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addOrganizationIds"), (long)0L);
        long[] removeOrganizationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeOrganizationIds"), (long)0L);
        if (ArrayUtil.isNotEmpty((long[])addUserIds)) {
            this._userService.addPasswordPolicyUsers(passwordPolicyId, addUserIds);
        }
        if (ArrayUtil.isNotEmpty((long[])removeUserIds)) {
            this._userService.unsetPasswordPolicyUsers(passwordPolicyId, removeUserIds);
        }
        if (ArrayUtil.isNotEmpty((long[])addOrganizationIds)) {
            this._organizationService.addPasswordPolicyOrganizations(passwordPolicyId, addOrganizationIds);
        }
        if (ArrayUtil.isNotEmpty((long[])removeOrganizationIds)) {
            this._organizationService.unsetPasswordPolicyOrganizations(passwordPolicyId, removeOrganizationIds);
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchPasswordPolicyException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include("/error.jsp", renderRequest, renderResponse);
        } else if (SessionErrors.contains((PortletRequest)renderRequest, (String)DuplicatePasswordPolicyException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)PasswordPolicyNameException.class.getName())) {
            this.include("/edit_password_policy.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof DuplicatePasswordPolicyException || cause instanceof NoSuchPasswordPolicyException || cause instanceof PasswordPolicyNameException || cause instanceof PrincipalException || cause instanceof RequiredPasswordPolicyException;
    }

    @Reference(unbind="-")
    protected void setOrganizationService(OrganizationService organizationService) {
        this._organizationService = organizationService;
    }

    @Reference(unbind="-")
    protected void setPasswordPolicyService(PasswordPolicyService passwordPolicyService) {
        this._passwordPolicyService = passwordPolicyService;
    }

    @Reference(unbind="-")
    protected void setUserService(UserService userService) {
        this._userService = userService;
    }
}

