/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.password.policies.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PasswordPolicyPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class PasswordPolicyDisplayContext {
    private final Long _passwordPolicyId;
    private final PermissionChecker _permissionChecker;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;

    public PasswordPolicyDisplayContext(HttpServletRequest request, RenderResponse renderResponse) {
        this._request = request;
        this._renderResponse = renderResponse;
        this._passwordPolicyId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"passwordPolicyId");
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._permissionChecker = themeDisplay.getPermissionChecker();
    }

    public List<NavigationItem> getEditPasswordPolicyAssignmentsNavigationItems(final PortletURL portletURL) {
        final String tabs2 = ParamUtil.getString((HttpServletRequest)this._request, (String)"tabs2", (String)"users");
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(tabs2.equals("users"));
                    navigationItem.setHref(portletURL, new Object[]{"tabs2", "users"});
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)PasswordPolicyDisplayContext.this._request, (String)"users"));
                });
                this.add(navigationItem -> {
                    navigationItem.setActive(tabs2.equals("organizations"));
                    navigationItem.setHref(portletURL, new Object[]{"tabs2", "organizations"});
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)PasswordPolicyDisplayContext.this._request, (String)"organizations"));
                });
            }
        };
    }

    public List<NavigationItem> getEditPasswordPolicyNavigationItems() throws PortletException {
        final String tabs1 = ParamUtil.getString((HttpServletRequest)this._request, (String)"tabs1", (String)"details");
        String redirect = ParamUtil.getString((HttpServletRequest)this._request, (String)"redirect");
        final PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("redirect", redirect);
        portletURL.setParameter("passwordPolicyId", String.valueOf(this._passwordPolicyId));
        NavigationItemList navigationItems = new NavigationItemList(){
            {
                if (PasswordPolicyDisplayContext.this._passwordPolicyId == 0L || PasswordPolicyDisplayContext.this._hasPermission("UPDATE")) {
                    this.add(SafeConsumer.ignore(navigationItem -> {
                        navigationItem.setActive(tabs1.equals("details"));
                        PortletURL detailsURL = PortletURLUtil.clone((PortletURL)portletURL, (MimeResponse)PasswordPolicyDisplayContext.this._renderResponse);
                        detailsURL.setParameter("mvcPath", "/edit_password_policy.jsp");
                        detailsURL.setParameter("tabs1", "details");
                        navigationItem.setHref((Object)detailsURL.toString());
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)PasswordPolicyDisplayContext.this._request, (String)"details"));
                    }));
                }
                if (PasswordPolicyDisplayContext.this._hasPermission("ASSIGN_MEMBERS")) {
                    this.add(SafeConsumer.ignore(navigationItem -> {
                        navigationItem.setActive(tabs1.equals("assignees"));
                        PortletURL assigneesURL = PortletURLUtil.clone((PortletURL)portletURL, (MimeResponse)PasswordPolicyDisplayContext.this._renderResponse);
                        assigneesURL.setParameter("mvcPath", "/edit_password_policy_assignments.jsp");
                        assigneesURL.setParameter("tabs1", "assignees");
                        navigationItem.setHref((Object)assigneesURL.toString());
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)PasswordPolicyDisplayContext.this._request, (String)"assignees"));
                    }));
                }
            }
        };
        if (navigationItems.isEmpty()) {
            return null;
        }
        return navigationItems;
    }

    public List<NavigationItem> getSelectMembersNavigationItems() {
        String tabs2 = ParamUtil.getString((HttpServletRequest)this._request, (String)"tabs2", (String)"users");
        ArrayList<NavigationItem> navigationItems = new ArrayList<NavigationItem>();
        NavigationItem entriesNavigationItem = new NavigationItem();
        entriesNavigationItem.setActive(true);
        entriesNavigationItem.setHref((Object)"");
        entriesNavigationItem.setLabel(LanguageUtil.get((HttpServletRequest)this._request, (String)tabs2));
        navigationItems.add(entriesNavigationItem);
        return navigationItems;
    }

    public List<NavigationItem> getViewPasswordPoliciesNavigationItems() {
        ArrayList<NavigationItem> navigationItems = new ArrayList<NavigationItem>();
        NavigationItem entriesNavigationItem = new NavigationItem();
        entriesNavigationItem.setActive(true);
        entriesNavigationItem.setHref((Object)"");
        entriesNavigationItem.setLabel(LanguageUtil.get((HttpServletRequest)this._request, (String)"password-policies"));
        navigationItems.add(entriesNavigationItem);
        return navigationItems;
    }

    public boolean hasPermission(String actionId, long passwordPolicyId) {
        return this._hasPermission(actionId, passwordPolicyId);
    }

    private boolean _hasPermission(String actionId) {
        return this._hasPermission(actionId, this._passwordPolicyId);
    }

    private boolean _hasPermission(String actionId, long passwordPolicyId) {
        if (passwordPolicyId <= 0L) {
            return false;
        }
        return PasswordPolicyPermissionUtil.contains((PermissionChecker)this._permissionChecker, (long)passwordPolicyId, (String)actionId);
    }
}

