/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.password.policies.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PasswordPolicyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class PasswordPolicyStagedModelDataHandler
extends BaseStagedModelDataHandler<PasswordPolicy> {
    public static final String[] CLASS_NAMES = new String[]{PasswordPolicy.class.getName()};
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private PasswordPolicyLocalService _passwordPolicyLocalService;

    public void deleteStagedModel(PasswordPolicy passwordPolicy) throws PortalException {
        this._passwordPolicyLocalService.deletePasswordPolicy(passwordPolicy);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        PasswordPolicy passwordPolicy = this._passwordPolicyLocalService.fetchPasswordPolicyByUuidAndCompanyId(uuid, group.getCompanyId());
        if (passwordPolicy != null) {
            this.deleteStagedModel(passwordPolicy);
        }
    }

    public List<PasswordPolicy> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return ListUtil.fromArray((Object[])new PasswordPolicy[]{this._passwordPolicyLocalService.fetchPasswordPolicyByUuidAndCompanyId(uuid, companyId)});
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, PasswordPolicy passwordPolicy) throws Exception {
        Element passwordPolicyElement = portletDataContext.getExportDataElement((ClassedModel)passwordPolicy);
        portletDataContext.addClassedModel(passwordPolicyElement, ExportImportPathUtil.getModelPath((StagedModel)passwordPolicy), (ClassedModel)passwordPolicy);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, PasswordPolicy passwordPolicy) throws Exception {
        long userId = portletDataContext.getUserId(passwordPolicy.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)passwordPolicy);
        PasswordPolicy existingPasswordPolicy = this._passwordPolicyLocalService.fetchPasswordPolicyByUuidAndCompanyId(passwordPolicy.getUuid(), portletDataContext.getCompanyId());
        if (existingPasswordPolicy == null) {
            existingPasswordPolicy = this._passwordPolicyLocalService.fetchPasswordPolicy(portletDataContext.getCompanyId(), passwordPolicy.getName());
        }
        PasswordPolicy importedPasswordPolicy = null;
        if (existingPasswordPolicy == null) {
            serviceContext.setUuid(passwordPolicy.getUuid());
            importedPasswordPolicy = this._passwordPolicyLocalService.addPasswordPolicy(userId, passwordPolicy.isDefaultPolicy(), passwordPolicy.getName(), passwordPolicy.getDescription(), passwordPolicy.isChangeable(), passwordPolicy.isChangeRequired(), passwordPolicy.getMinAge(), passwordPolicy.isCheckSyntax(), passwordPolicy.isAllowDictionaryWords(), passwordPolicy.getMinAlphanumeric(), passwordPolicy.getMinLength(), passwordPolicy.getMinLowerCase(), passwordPolicy.getMinNumbers(), passwordPolicy.getMinSymbols(), passwordPolicy.getMinUpperCase(), passwordPolicy.getRegex(), passwordPolicy.isHistory(), passwordPolicy.getHistoryCount(), passwordPolicy.isExpireable(), passwordPolicy.getMaxAge(), passwordPolicy.getWarningTime(), passwordPolicy.getGraceLimit(), passwordPolicy.isLockout(), passwordPolicy.getMaxFailure(), passwordPolicy.getLockoutDuration(), passwordPolicy.getResetFailureCount(), passwordPolicy.getResetTicketMaxAge(), serviceContext);
        } else {
            importedPasswordPolicy = this._passwordPolicyLocalService.updatePasswordPolicy(existingPasswordPolicy.getPasswordPolicyId(), passwordPolicy.getName(), passwordPolicy.getDescription(), passwordPolicy.isChangeable(), passwordPolicy.isChangeRequired(), passwordPolicy.getMinAge(), passwordPolicy.isCheckSyntax(), passwordPolicy.isAllowDictionaryWords(), passwordPolicy.getMinAlphanumeric(), passwordPolicy.getMinLength(), passwordPolicy.getMinLowerCase(), passwordPolicy.getMinNumbers(), passwordPolicy.getMinSymbols(), passwordPolicy.getMinUpperCase(), passwordPolicy.getRegex(), passwordPolicy.isHistory(), passwordPolicy.getHistoryCount(), passwordPolicy.isExpireable(), passwordPolicy.getMaxAge(), passwordPolicy.getWarningTime(), passwordPolicy.getGraceLimit(), passwordPolicy.isLockout(), passwordPolicy.getMaxFailure(), passwordPolicy.getLockoutDuration(), passwordPolicy.getResetFailureCount(), passwordPolicy.getResetTicketMaxAge(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)passwordPolicy, (ClassedModel)importedPasswordPolicy);
    }
}

