/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.util.configuration;

import com.liferay.osgi.util.StringPlus;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConfigurationFactoryUtil {
    public static long getCompanyId(CompanyLocalService companyLocalService, Map<String, Object> properties) throws IllegalStateException {
        long companyId = GetterUtil.getLong((Object)properties.get("companyId"));
        if (companyId > 0L) {
            return companyId;
        }
        String webId = (String)properties.get("dxp.lxc.liferay.com.virtualInstanceId");
        if (Objects.equals(webId, "default")) {
            webId = PropsValues.COMPANY_DEFAULT_WEB_ID;
        }
        if (Validator.isNull((String)webId)) {
            throw new IllegalStateException("The property \"companyId\" or \"dxp.lxc.liferay.com.virtualInstanceId\" must be set");
        }
        try {
            Company company = companyLocalService.getCompanyByWebId(webId);
            return company.getCompanyId();
        }
        catch (PortalException portalException) {
            throw new IllegalStateException(portalException);
        }
    }

    public static String getExternalReferenceCode(Map<String, Object> properties) throws IllegalStateException {
        String serviceFactoryPid = GetterUtil.getString((Object)properties.get("service.factoryPid"));
        if (Validator.isNull((String)serviceFactoryPid)) {
            throw new IllegalStateException("Service factory PID is null");
        }
        List<String> servicePids = StringPlus.asList(properties.get("service.pid"));
        if (servicePids.isEmpty()) {
            throw new IllegalStateException("Service PID is null");
        }
        String servicePid = servicePids.get(0);
        if (!servicePid.startsWith(serviceFactoryPid)) {
            throw new IllegalStateException(StringBundler.concat((String[])new String[]{"Service PID (", servicePid, ") does not start with ", "service factory PID (", serviceFactoryPid, ")"}));
        }
        return servicePid.substring(serviceFactoryPid.length() + 1);
    }
}

