/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.util;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ComponentUtil {
    public static <T> void enableComponents(Class<T> referenceClass, String filterString, ComponentContext componentContext, Class<?> ... componentClasses) {
        AwaitReferenceServiceTrackerCustomizer<T> awaitReferenceServiceTrackerCustomizer = new AwaitReferenceServiceTrackerCustomizer<T>(componentContext, componentClasses);
        Object serviceTracker = null;
        serviceTracker = Validator.isNull((String)filterString) ? ServiceTrackerFactory.create(componentContext.getBundleContext(), referenceClass, awaitReferenceServiceTrackerCustomizer) : ServiceTrackerFactory.create(componentContext.getBundleContext(), StringBundler.concat((String[])new String[]{"(&(objectClass=", referenceClass.getName(), ")", filterString, ")"}), awaitReferenceServiceTrackerCustomizer);
        awaitReferenceServiceTrackerCustomizer.setServiceTracker((ServiceTracker<T, T>)serviceTracker);
        serviceTracker.open();
    }

    private static class AwaitReferenceServiceTrackerCustomizer<T>
    implements ServiceTrackerCustomizer<T, T> {
        private final Class<?>[] _componentClasses;
        private final ComponentContext _componentContext;
        private ServiceTracker<T, T> _serviceTracker;

        public T addingService(ServiceReference<T> serviceReference) {
            for (Class<?> componentClass : this._componentClasses) {
                this._componentContext.enableComponent(componentClass.getName());
            }
            this._serviceTracker.close();
            return null;
        }

        public void modifiedService(ServiceReference<T> serviceReference, T object) {
        }

        public void removedService(ServiceReference<T> serviceReference, T object) {
        }

        public void setServiceTracker(ServiceTracker<T, T> serviceTracker) {
            this._serviceTracker = serviceTracker;
        }

        private AwaitReferenceServiceTrackerCustomizer(ComponentContext componentContext, Class<?>[] componentClasses) {
            this._componentContext = componentContext;
            this._componentClasses = componentClasses;
        }
    }
}

