/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.util.bundle;

import com.liferay.petra.concurrent.DefaultNoticeableFuture;
import java.util.Collections;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;

public class BundleStartLevelUtil {
    public static void setStartLevelAndStart(Bundle bundle, int startLevel, BundleContext bundleContext) throws Exception {
        Bundle systemBundle = bundleContext.getBundle(0L);
        FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)systemBundle.adapt(FrameworkStartLevel.class);
        BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        if (frameworkStartLevel.getStartLevel() >= startLevel) {
            BundleStartLevelUtil._startBundle(bundle, bundleContext);
            bundleStartLevel.setStartLevel(startLevel);
        } else {
            bundleStartLevel.setStartLevel(startLevel);
            BundleStartLevelUtil._startBundle(bundle, bundleContext);
        }
    }

    private static void _startBundle(Bundle bundle, BundleContext bundleContext) throws Exception {
        Dictionary headers = bundle.getHeaders("");
        String fragmentHost = (String)headers.get("Fragment-Host");
        if (fragmentHost == null) {
            bundle.start();
        } else {
            for (Bundle installedBundle : bundleContext.getBundles()) {
                if (!fragmentHost.equals(installedBundle.getSymbolicName())) continue;
                Bundle systemBundle = bundleContext.getBundle(0L);
                FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
                final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
                frameworkWiring.refreshBundles(Collections.singletonList(installedBundle), new FrameworkListener[]{new FrameworkListener(){

                    public void frameworkEvent(FrameworkEvent frameworkEvent) {
                        defaultNoticeableFuture.set((Object)frameworkEvent);
                    }
                }});
                defaultNoticeableFuture.get();
                break;
            }
        }
    }
}

