/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.util;

import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import java.util.function.Function;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerFactory {
    public static <T> ServiceTracker<T, T> create(Bundle bundle, Class<T> clazz) {
        return new ServiceTracker(bundle.getBundleContext(), clazz, null);
    }

    public static <S, T> ServiceTracker<S, T> create(BundleContext bundleContext, Class<S> clazz, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        return new ServiceTracker(bundleContext, clazz, serviceTrackerCustomizer);
    }

    public static <S, T> ServiceTracker<S, T> create(BundleContext bundleContext, String filterString) {
        try {
            return new ServiceTracker(bundleContext, bundleContext.createFilter(filterString), null);
        }
        catch (InvalidSyntaxException ise) {
            ServiceTrackerFactory.throwException(ise);
            return null;
        }
    }

    public static <S, T> ServiceTracker<S, T> create(BundleContext bundleContext, String filterString, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        try {
            return new ServiceTracker(bundleContext, bundleContext.createFilter(filterString), serviceTrackerCustomizer);
        }
        catch (InvalidSyntaxException ise) {
            ServiceTrackerFactory.throwException(ise);
            return null;
        }
    }

    public static <T> ServiceTracker<T, T> create(Class<T> clazz) {
        return ServiceTrackerFactory.create(FrameworkUtil.getBundle(ServiceTrackerFactory.class), clazz);
    }

    public static <T> ServiceTracker<T, T> open(Bundle bundle, Class<T> clazz) {
        ServiceTracker<T, T> serviceTracker = ServiceTrackerFactory.create(bundle, clazz);
        serviceTracker.open();
        return serviceTracker;
    }

    public static <S, T> ServiceTracker<S, T> open(BundleContext bundleContext, Class<S> clazz, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        ServiceTracker<S, T> serviceTracker = ServiceTrackerFactory.create(bundleContext, clazz, serviceTrackerCustomizer);
        serviceTracker.open();
        return serviceTracker;
    }

    public static <S, T> ServiceTracker<S, T> open(BundleContext bundleContext, String filterString) {
        ServiceTracker<S, T> serviceTracker = ServiceTrackerFactory.create(bundleContext, filterString);
        serviceTracker.open();
        return serviceTracker;
    }

    public static <S, T> ServiceTracker<S, T> open(BundleContext bundleContext, String filterString, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        ServiceTracker<S, T> serviceTracker = ServiceTrackerFactory.create(bundleContext, filterString, serviceTrackerCustomizer);
        serviceTracker.open();
        return serviceTracker;
    }

    public static <T> ServiceTracker<T, T> open(Class<T> clazz) {
        ServiceTracker<T, T> serviceTracker = ServiceTrackerFactory.create(clazz);
        serviceTracker.open();
        return serviceTracker;
    }

    public static <T, W> ServiceTracker<T, ServiceRegistration<W>> openWrapperServiceRegistrator(final BundleContext bundleContext, Class<T> trackedClass, final Class<W> registeredClass, final Function<T, W> wrapperFunction, final String ... propertyNames) {
        return ServiceTrackerFactory.open(bundleContext, trackedClass, new ServiceTrackerCustomizer<T, ServiceRegistration<W>>(){

            public ServiceRegistration<W> addingService(ServiceReference<T> serviceReference) {
                return bundleContext.registerService(registeredClass, wrapperFunction.apply(bundleContext.getService(serviceReference)), this._buildProperties(serviceReference));
            }

            public void modifiedService(ServiceReference<T> serviceReference, ServiceRegistration<W> serviceRegistration) {
                serviceRegistration.setProperties(this._buildProperties(serviceReference));
            }

            public void removedService(ServiceReference<T> serviceReference, ServiceRegistration<W> serviceRegistration) {
                serviceRegistration.unregister();
                bundleContext.ungetService(serviceReference);
            }

            private Dictionary<String, Object> _buildProperties(ServiceReference<?> serviceReference) {
                HashMapDictionary properties = new HashMapDictionary();
                for (String propertyName : propertyNames) {
                    properties.put(propertyName, serviceReference.getProperty(propertyName));
                }
                properties.put("original.service.id", serviceReference.getProperty("service.id"));
                return properties;
            }
        });
    }

    public static <T> T throwException(Throwable throwable) {
        return ServiceTrackerFactory._throwException(throwable);
    }

    private static <T, E extends Throwable> T _throwException(Throwable throwable) throws E {
        throw throwable;
    }
}

