/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections.internal.map;

import com.liferay.osgi.service.tracker.collections.ServiceReferenceServiceTuple;
import com.liferay.osgi.service.tracker.collections.internal.ServiceReferenceServiceTupleComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerBucket;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerBucketFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.ServiceReference;

public class SingleValueServiceTrackerBucketFactory<SR, TS>
implements ServiceTrackerBucketFactory<SR, TS, TS> {
    private final Comparator<ServiceReference<SR>> _comparator;

    public SingleValueServiceTrackerBucketFactory() {
        this._comparator = Collections.reverseOrder();
    }

    public SingleValueServiceTrackerBucketFactory(Comparator<ServiceReference<SR>> comparator) {
        this._comparator = comparator;
    }

    @Override
    public ServiceTrackerBucket<SR, TS, TS> create() {
        return new SingleBucket();
    }

    static /* synthetic */ Comparator access$100(SingleValueServiceTrackerBucketFactory x0) {
        return x0._comparator;
    }

    private class SingleBucket
    implements ServiceTrackerBucket<SR, TS, TS> {
        private TS _service;
        private final List<ServiceReferenceServiceTuple<SR, TS>> _serviceReferences = new ArrayList(1);
        private final ServiceReferenceServiceTupleComparator<SR> _serviceReferenceServiceTupleComparator = new ServiceReferenceServiceTupleComparator(SingleValueServiceTrackerBucketFactory.access$100(SingleValueServiceTrackerBucketFactory.this));

        private SingleBucket() {
        }

        @Override
        public TS getContent() {
            return this._service;
        }

        @Override
        public synchronized boolean isDisposable() {
            return this._serviceReferences.isEmpty();
        }

        @Override
        public synchronized void remove(ServiceReferenceServiceTuple<SR, TS> serviceReferenceServiceTuple) {
            this._serviceReferences.remove(serviceReferenceServiceTuple);
            if (this._serviceReferences.isEmpty()) {
                this._service = null;
            } else {
                ServiceReferenceServiceTuple headServiceReferenceServiceTuple = this._serviceReferences.get(0);
                this._service = headServiceReferenceServiceTuple.getService();
            }
        }

        @Override
        public synchronized void store(ServiceReferenceServiceTuple<SR, TS> serviceReferenceServiceTuple) {
            int index = Collections.binarySearch(this._serviceReferences, serviceReferenceServiceTuple, this._serviceReferenceServiceTupleComparator);
            if (index < 0) {
                index = -index - 1;
            }
            this._serviceReferences.add(index, serviceReferenceServiceTuple);
            ServiceReferenceServiceTuple headServiceReferenceServiceTuple = this._serviceReferences.get(0);
            this._service = headServiceReferenceServiceTuple.getService();
        }
    }
}

