/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections;

import com.liferay.osgi.service.tracker.collections.internal.DefaultServiceTrackerCustomizer;
import com.liferay.osgi.service.tracker.collections.internal.map.MultiValueServiceTrackerBucketFactory;
import com.liferay.osgi.service.tracker.collections.internal.map.ServiceTrackerMapImpl;
import com.liferay.osgi.service.tracker.collections.internal.map.SingleValueServiceTrackerBucketFactory;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerBucketFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerMapBuilder {

    private static class SelectorImpl<T, NR>
    implements Selector<T, NR> {
        private final BundleContext _bundleContext;
        private final Class<T> _clazz;
        private final String _filterString;
        private final ServiceTrackerCustomizer<T, NR> _serviceTrackerCustomizer;

        @Override
        public <K> Mapper<K, T, NR, ?> map(ServiceReferenceMapper<K, T> serviceReferenceMapper) {
            return new MapperImpl(this._bundleContext, this._clazz, this._serviceTrackerCustomizer, serviceReferenceMapper, null);
        }

        @Override
        public Mapper<String, T, NR, NR> map(String propertyKey) {
            String filterString = this._filterString;
            if (filterString == null) {
                filterString = "(" + propertyKey + "=*)";
            }
            return new MapperImpl(this._bundleContext, this._clazz, this._serviceTrackerCustomizer, new PropertyServiceReferenceMapper(propertyKey), filterString);
        }

        @Override
        public <NR> Selector<T, NR> newSelector(ServiceTrackerCustomizer<T, NR> serviceTrackerCustomizer) {
            return new SelectorImpl<T, NR>(this._bundleContext, this._clazz, this._filterString, serviceTrackerCustomizer);
        }

        @Override
        public Selector<T, NR> newSelector(String filterString) {
            return new SelectorImpl<T, NR>(this._bundleContext, this._clazz, filterString, this._serviceTrackerCustomizer);
        }

        private SelectorImpl(BundleContext bundleContext, Class<T> clazz, String filterString, ServiceTrackerCustomizer<T, NR> serviceTrackerCustomizer) {
            this._bundleContext = bundleContext;
            this._clazz = clazz;
            this._filterString = filterString;
            this._serviceTrackerCustomizer = serviceTrackerCustomizer;
        }
    }

    private static class MapperImpl<K, SR, NR, R>
    implements Mapper<K, SR, NR, R> {
        private final BundleContext _bundleContext;
        private final Class<SR> _clazz;
        private final String _filterString;
        private final ServiceReferenceMapper<K, SR> _serviceReferenceMapper;
        private final ServiceTrackerCustomizer<SR, NR> _serviceTrackerCustomizer;

        @Override
        public <R> Collector<K, SR, NR, R> collect(ServiceTrackerBucketFactory<SR, NR, R> serviceTrackerBucketFactory) {
            return new CollectorImpl(this._bundleContext, this._clazz, this._serviceTrackerCustomizer, this._filterString, this._serviceReferenceMapper, serviceTrackerBucketFactory, null);
        }

        @Override
        public Collector<K, SR, NR, List<NR>> collectMultiValue() {
            return new CollectorImpl(this._bundleContext, this._clazz, this._serviceTrackerCustomizer, this._filterString, this._serviceReferenceMapper, new MultiValueServiceTrackerBucketFactory(), null);
        }

        @Override
        public Collector<K, SR, NR, List<NR>> collectMultiValue(Comparator<ServiceReference<SR>> comparator) {
            return new CollectorImpl(this._bundleContext, this._clazz, this._serviceTrackerCustomizer, this._filterString, this._serviceReferenceMapper, new MultiValueServiceTrackerBucketFactory(comparator), null);
        }

        @Override
        public Collector<K, SR, NR, NR> collectSingleValue() {
            return new CollectorImpl(this._bundleContext, this._clazz, this._serviceTrackerCustomizer, this._filterString, this._serviceReferenceMapper, new SingleValueServiceTrackerBucketFactory(), null);
        }

        @Override
        public Collector<K, SR, NR, NR> collectSingleValue(Comparator<ServiceReference<SR>> comparator) {
            return new CollectorImpl(this._bundleContext, this._clazz, this._serviceTrackerCustomizer, this._filterString, this._serviceReferenceMapper, new SingleValueServiceTrackerBucketFactory(comparator), null);
        }

        private MapperImpl(BundleContext bundleContext, Class<SR> clazz, ServiceTrackerCustomizer<SR, NR> serviceTrackerCustomizer, ServiceReferenceMapper<K, SR> serviceReferenceMapper, String filterString) {
            this._bundleContext = bundleContext;
            this._clazz = clazz;
            this._serviceTrackerCustomizer = serviceTrackerCustomizer;
            this._serviceReferenceMapper = serviceReferenceMapper;
            this._filterString = filterString;
        }
    }

    private static class CollectorImpl<K, SR, NR, R>
    implements Collector<K, SR, NR, R> {
        private final BundleContext _bundleContext;
        private final Class<SR> _clazz;
        private final String _filterString;
        private final ServiceReferenceMapper<K, SR> _serviceReferenceMapper;
        private final ServiceTrackerBucketFactory<SR, NR, R> _serviceTrackerBucketFactory;
        private final ServiceTrackerCustomizer<SR, NR> _serviceTrackerCustomizer;
        private final ServiceTrackerMapListener<K, NR, R> _serviceTrackerMapListener;

        @Override
        public ServiceTrackerMap<K, R> build() {
            ServiceTrackerMapImpl<K, SR, NR, R> serviceTrackerMap = new ServiceTrackerMapImpl<K, SR, NR, R>(this._bundleContext, this._clazz, this._filterString, this._serviceReferenceMapper, this._serviceTrackerCustomizer, this._serviceTrackerBucketFactory, this._serviceTrackerMapListener);
            return serviceTrackerMap;
        }

        @Override
        public Collector<K, SR, NR, R> newCollector(ServiceTrackerMapListener<K, NR, R> serviceTrackerMapListener) {
            return new CollectorImpl<K, SR, NR, R>(this._bundleContext, this._clazz, this._serviceTrackerCustomizer, this._filterString, this._serviceReferenceMapper, this._serviceTrackerBucketFactory, serviceTrackerMapListener);
        }

        private CollectorImpl(BundleContext bundleContext, Class<SR> clazz, ServiceTrackerCustomizer<SR, NR> serviceTrackerCustomizer, String filterString, ServiceReferenceMapper<K, SR> serviceReferenceMapper, ServiceTrackerBucketFactory<SR, NR, R> serviceTrackerBucketFactory, ServiceTrackerMapListener<K, NR, R> serviceTrackerMapListener) {
            this._bundleContext = bundleContext;
            this._clazz = clazz;
            this._serviceTrackerCustomizer = serviceTrackerCustomizer == null ? new DefaultServiceTrackerCustomizer<NR>(this._bundleContext) : serviceTrackerCustomizer;
            this._filterString = filterString;
            this._serviceReferenceMapper = serviceReferenceMapper;
            this._serviceTrackerBucketFactory = serviceTrackerBucketFactory;
            this._serviceTrackerMapListener = serviceTrackerMapListener;
        }
    }

    public static interface SelectorFactory {
        public static <T> Selector<T, T> newSelector(BundleContext bundleContext, Class<T> clazz) {
            return new SelectorImpl(bundleContext, clazz, null, null);
        }

        public static <T> Selector<T, T> newSelector(BundleContext bundleContext, Class<T> clazz, String filterString) {
            return new SelectorImpl(bundleContext, clazz, filterString, null);
        }

        public static Selector<Object, Object> newSelector(BundleContext bundleContext, String className) {
            return new SelectorImpl<Object, Object>(bundleContext, Object.class, "(objectClass=" + className + ")", null);
        }

        public static Selector<?, ?> newSelectorWithFilter(BundleContext bundleContext, String filterString) {
            return new SelectorImpl(bundleContext, Object.class, filterString, null);
        }
    }

    public static interface Selector<SR, NR> {
        public <K> Mapper<K, SR, NR, ?> map(ServiceReferenceMapper<K, SR> var1);

        public Mapper<String, SR, NR, NR> map(String var1);

        public <NR> Selector<SR, NR> newSelector(ServiceTrackerCustomizer<SR, NR> var1);

        public Selector<SR, NR> newSelector(String var1);
    }

    public static interface Mapper<K, SR, NR, R> {
        public <R> Collector<K, SR, NR, R> collect(ServiceTrackerBucketFactory<SR, NR, R> var1);

        public Collector<K, SR, NR, List<NR>> collectMultiValue();

        public Collector<K, SR, NR, List<NR>> collectMultiValue(Comparator<ServiceReference<SR>> var1);

        public Collector<K, SR, NR, NR> collectSingleValue();

        public Collector<K, SR, NR, NR> collectSingleValue(Comparator<ServiceReference<SR>> var1);
    }

    public static interface Collector<K, SR, NR, R> {
        public ServiceTrackerMap<K, R> build();

        public Collector<K, SR, NR, R> newCollector(ServiceTrackerMapListener<K, NR, R> var1);
    }
}

