/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.organizations.internal.object.system;

import com.liferay.headless.admin.user.dto.v1_0.Organization;
import com.liferay.headless.admin.user.resource.v1_0.OrganizationResource;
import com.liferay.object.field.builder.LongIntegerObjectFieldBuilder;
import com.liferay.object.field.builder.TextObjectFieldBuilder;
import com.liferay.object.model.ObjectField;
import com.liferay.object.system.BaseSystemObjectDefinitionManager;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.OrganizationTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SystemObjectDefinitionManager.class})
public class OrganizationSystemObjectDefinitionManager
extends BaseSystemObjectDefinitionManager {
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private OrganizationResource.Factory _organizationResourceFactory;

    public long addBaseModel(User user, Map<String, Object> values) throws Exception {
        OrganizationResource organizationResource = this._buildOrganizationResource(false, user);
        Organization organization = organizationResource.postOrganization(this._toOrganization(values));
        this.setExtendedProperties(Organization.class.getName(), organization, user, values);
        return GetterUtil.getLong((String)organization.getId());
    }

    public BaseModel<?> deleteBaseModel(BaseModel<?> baseModel) throws PortalException {
        return this._organizationLocalService.deleteOrganization((com.liferay.portal.kernel.model.Organization)baseModel);
    }

    public BaseModel<?> fetchBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this._organizationLocalService.fetchOrganizationByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public BaseModel<?> getBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this._organizationLocalService.getOrganizationByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public String getBaseModelExternalReferenceCode(long primaryKey) throws PortalException {
        com.liferay.portal.kernel.model.Organization organization = this._organizationLocalService.getOrganization(primaryKey);
        return organization.getExternalReferenceCode();
    }

    public String getExternalReferenceCode() {
        return "L_ORGANIZATION";
    }

    public JaxRsApplicationDescriptor getJaxRsApplicationDescriptor() {
        return new JaxRsApplicationDescriptor("Liferay.Headless.Admin.User", "headless-admin-user", "organizations", "v1.0");
    }

    public Map<String, String> getLabelKeys() {
        return HashMapBuilder.put((Object)"label", (Object)"organization").put((Object)"pluralLabel", (Object)"organizations").build();
    }

    public Class<?> getModelClass() {
        return com.liferay.portal.kernel.model.Organization.class;
    }

    public List<ObjectField> getObjectFields() {
        return Arrays.asList(new LongIntegerObjectFieldBuilder().labelMap(this.createLabelMap("parentOrganizationId")).name("parentOrganizationId").system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("comments")).name("comment").system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("name")).name("name").required(true).system(true).build());
    }

    public Page<?> getPage(User user, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        OrganizationResource organizationResource = this._buildOrganizationResource(true, user);
        return organizationResource.getOrganizationsPage(null, search, filter, pagination, sorts);
    }

    public Column<?, Long> getPrimaryKeyColumn() {
        return OrganizationTable.INSTANCE.organizationId;
    }

    public String getScope() {
        return "company";
    }

    public Table getTable() {
        return OrganizationTable.INSTANCE;
    }

    public String getTitleObjectFieldName() {
        return "name";
    }

    public int getVersion() {
        return 3;
    }

    public void updateBaseModel(long primaryKey, User user, Map<String, Object> values) throws Exception {
        throw new UnsupportedOperationException();
    }

    private OrganizationResource _buildOrganizationResource(boolean checkPermissions, User user) {
        OrganizationResource.Builder builder = this._organizationResourceFactory.create();
        return builder.checkPermissions(checkPermissions).preferredLocale(user.getLocale()).user(user).build();
    }

    private Organization _toOrganization(final Map<String, Object> values) {
        return new Organization(){
            {
                this.setComment(() -> GetterUtil.getString(values.get("comment")));
                this.setName(() -> GetterUtil.getString(values.get("name")));
            }
        };
    }
}

