/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.organization.apio.internal.architect.resource;

import com.liferay.address.apio.architect.identifier.AddressIdentifier;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.NestedRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.CollectionResource;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.email.apio.architect.identifier.EmailIdentifier;
import com.liferay.organization.apio.architect.identifier.OrganizationIdentifier;
import com.liferay.organization.apio.internal.model.OpeningHours;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.petra.string.StringBundler;
import com.liferay.phone.apio.architect.identifier.PhoneIdentifier;
import com.liferay.portal.apio.identifier.ClassNameClassPK;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.ListTypeModel;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.OrganizationModel;
import com.liferay.portal.kernel.model.RegionModel;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.OrgLaborService;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.site.apio.architect.identifier.WebSiteIdentifier;
import com.liferay.web.url.apio.architect.identifier.WebUrlIdentifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CollectionResource.class})
public class OrganizationCollectionResource
implements CollectionResource<Organization, Long, OrganizationIdentifier> {
    @Reference
    private CountryService _countryService;
    @Reference
    private GroupService _groupService;
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private OrgLaborService _orgLaborService;
    @Reference
    private Portal _portal;
    @Reference
    private RegionService _regionService;

    public CollectionRoutes<Organization, Long> collectionRoutes(CollectionRoutes.Builder<Organization, Long> builder) {
        return builder.addGetter(this::_getPageItems, Company.class).build();
    }

    public String getName() {
        return "organization";
    }

    public ItemRoutes<Organization, Long> itemRoutes(ItemRoutes.Builder<Organization, Long> builder) {
        return builder.addGetter(arg_0 -> ((OrganizationService)this._organizationService).getOrganization(arg_0)).build();
    }

    public Representor<Organization> representor(Representor.Builder<Organization, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("Organization", new String[0]).identifier(OrganizationModel::getOrganizationId).addBidirectionalModel("parentOrganization", "subOrganization", OrganizationIdentifier.class, OrganizationCollectionResource::_getParentOrganizationId).addLinkedModel("website", WebSiteIdentifier.class, this::_getSiteId)).addNested("contactInformation", Function.identity(), organizationBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)organizationBuilder.types("ContactInformation", new String[0]).addRelatedCollection("address", AddressIdentifier.class, this::_createClassNameClassPK)).addRelatedCollection("email", EmailIdentifier.class, this::_createClassNameClassPK)).addRelatedCollection("telephone", PhoneIdentifier.class, this::_createClassNameClassPK)).addRelatedCollection("webUrl", WebUrlIdentifier.class, this::_createClassNameClassPK)).build())).addNested("location", organization -> organization, nestedBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)nestedBuilder.types("PostalAddress", new String[0]).addLocalizedStringByLocale("addressCountry", this::_getCountry)).addString("addressRegion", this::_getRegion)).build())).addNestedList("services", this::_getOrgLabors, this::_getServiceNestedRepresentorFunction)).addRelatedCollection("members", PersonIdentifier.class).addRelativeURL("logo", this::_getLogoURL)).addString("comment", OrganizationModel::getComments)).addString("name", OrganizationModel::getName)).build();
    }

    private static Long _getParentOrganizationId(Organization organization) {
        long parentOrganizationId = organization.getParentOrganizationId();
        if (parentOrganizationId <= 0L) {
            return null;
        }
        return parentOrganizationId;
    }

    private ClassNameClassPK _createClassNameClassPK(Organization organization) {
        return ClassNameClassPK.create((String)Organization.class.getName(), (long)organization.getOrganizationId());
    }

    private String _getCountry(Organization organization, Locale locale) {
        return (String)Try.success((Object)organization.getCountryId()).map(arg_0 -> ((CountryService)this._countryService).getCountry(arg_0)).map(country -> country.getName(locale)).orElse(null);
    }

    private List<OpeningHours> _getDay(OrgLabor orgLabor) {
        OpeningHours[] openingHoursArray = new OpeningHours[7];
        openingHoursArray[0] = new OpeningHours("Friday", () -> ((OrgLabor)orgLabor).getFriOpen(), () -> ((OrgLabor)orgLabor).getFriClose());
        openingHoursArray[1] = new OpeningHours("Monday", () -> ((OrgLabor)orgLabor).getMonOpen(), () -> ((OrgLabor)orgLabor).getMonClose());
        openingHoursArray[2] = new OpeningHours("Thursday", () -> ((OrgLabor)orgLabor).getThuOpen(), () -> ((OrgLabor)orgLabor).getThuClose());
        openingHoursArray[3] = new OpeningHours("Tuesday", () -> ((OrgLabor)orgLabor).getTueOpen(), () -> ((OrgLabor)orgLabor).getTueClose());
        openingHoursArray[4] = new OpeningHours("Saturday", () -> ((OrgLabor)orgLabor).getSatOpen(), () -> ((OrgLabor)orgLabor).getSatClose());
        openingHoursArray[5] = new OpeningHours("Sunday", () -> ((OrgLabor)orgLabor).getSunOpen(), () -> ((OrgLabor)orgLabor).getSunClose());
        openingHoursArray[6] = new OpeningHours("Wednesday", () -> ((OrgLabor)orgLabor).getWedOpen(), () -> ((OrgLabor)orgLabor).getWedClose());
        return Arrays.asList(openingHoursArray);
    }

    private String _getLogoURL(Organization organization) {
        return (String)Try.success((Object)organization.getLogoId()).filter(logoId -> logoId != 0L).map(logoId -> StringBundler.concat((Object[])new Object[]{this._portal.getPathImage(), "/organization_logo?img_id=", logoId, "&t=", WebServerServletTokenUtil.getToken((long)logoId)})).orElse(null);
    }

    private List<OrgLabor> _getOrgLabors(Organization organization) {
        return (List)Try.fromFallible(() -> this._orgLaborService.getOrgLabors(organization.getOrganizationId())).orElse(null);
    }

    private String _getOrgLaborType(OrgLabor orgLabor) {
        return (String)Try.fromFallible(() -> ((OrgLabor)orgLabor).getType()).map(ListTypeModel::getName).orElse(null);
    }

    private PageItems<Organization> _getPageItems(Pagination pagination, Company company) {
        List organizations = this._organizationService.getOrganizations(company.getCompanyId(), 0L, pagination.getStartPosition(), pagination.getEndPosition());
        int count = this._organizationService.getOrganizationsCount(company.getCompanyId(), 0L);
        return new PageItems((Collection)organizations, count);
    }

    private String _getRegion(Organization organization) {
        return (String)Try.success((Object)organization.getRegionId()).map(arg_0 -> ((RegionService)this._regionService).getRegion(arg_0)).map(RegionModel::getName).orElse(null);
    }

    private NestedRepresentor<OrgLabor> _getServiceNestedRepresentorFunction(NestedRepresentor.Builder<OrgLabor> orgLaborBuilder) {
        return (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)orgLaborBuilder.types("Service", new String[0]).addString("serviceType", this::_getOrgLaborType)).addNestedList("hoursAvailable", this::_getDay, nestedBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)nestedBuilder.types("OpeningHoursSpecification", new String[0]).addString("closes", OpeningHours::getCloses)).addString("dayOfWeek", OpeningHours::getDay)).addString("opens", OpeningHours::getOpens)).build())).build();
    }

    private Long _getSiteId(Organization organization) {
        return (Long)Try.success((Object)organization.getGroupId()).map(arg_0 -> ((GroupService)this._groupService).getGroup(arg_0)).filter(GroupModel::isSite).map(GroupModel::getGroupId).orElse(null);
    }
}

