/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.organization.apio.internal.model;

import com.liferay.apio.architect.functional.Try;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.function.Supplier;

public class OpeningHours {
    private final String _closes;
    private final String _day;
    private final String _opens;

    public OpeningHours(String day, Supplier<Integer> openSupplier, Supplier<Integer> closeSupplier) {
        this._day = day;
        this._opens = this._getHours(openSupplier.get());
        this._closes = this._getHours(closeSupplier.get());
    }

    public String getCloses() {
        return this._closes;
    }

    public String getDay() {
        return this._day;
    }

    public String getOpens() {
        return this._opens;
    }

    private String _formatHour(int hour) {
        DecimalFormat decimalFormat = new DecimalFormat("00,00");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setGroupingSeparator(':');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setGroupingSize(2);
        return decimalFormat.format(hour);
    }

    private String _getHours(Integer hours) {
        return (String)Try.fromFallible(() -> hours).filter(value -> value != -1).map(this::_formatHour).orElse(null);
    }
}

