/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.organization.apio.internal.architect.resource;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.NestedRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.CollectionResource;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.organization.apio.architect.identifier.OrganizationIdentifier;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.OrganizationModel;
import com.liferay.portal.kernel.model.RegionModel;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationService;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.site.apio.architect.identifier.WebSiteIdentifier;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class OrganizationCollectionResource
implements CollectionResource<Organization, Long, OrganizationIdentifier> {
    @Reference
    private CountryService _countryService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private OrganizationService _organizationService;
    @Reference
    private Portal _portal;
    @Reference
    private RegionService _regionService;

    public CollectionRoutes<Organization, Long> collectionRoutes(CollectionRoutes.Builder<Organization, Long> builder) {
        return builder.addGetter(this::_getPageItems, Company.class).build();
    }

    public String getName() {
        return "organization";
    }

    public ItemRoutes<Organization, Long> itemRoutes(ItemRoutes.Builder<Organization, Long> builder) {
        return builder.addGetter(arg_0 -> ((OrganizationService)this._organizationService).getOrganization(arg_0)).build();
    }

    public Representor<Organization> representor(Representor.Builder<Organization, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("Organization", new String[0]).identifier(OrganizationModel::getOrganizationId).addBidirectionalModel("parentOrganization", "subOrganizations", OrganizationIdentifier.class, OrganizationCollectionResource::_getParentOrganizationId).addLinkedModel("website", WebSiteIdentifier.class, this::_getSiteId)).addNested("location", organization -> organization, nestedBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)nestedBuilder.types("PostalAddress", new String[0]).addLocalizedStringByLocale("addressCountry", this::_getCountry)).addString("addressRegion", this::_getRegion)).build())).addRelatedCollection("members", PersonIdentifier.class).addRelativeURL("logo", this::_getLogoURL)).addString("name", OrganizationModel::getName)).build();
    }

    private static Long _getParentOrganizationId(Organization organization) {
        long parentOrganizationId = organization.getParentOrganizationId();
        if (parentOrganizationId <= 0L) {
            return null;
        }
        return parentOrganizationId;
    }

    private String _getCountry(Organization organization, Locale locale) {
        return (String)Try.success((Object)organization.getCountryId()).map(arg_0 -> ((CountryService)this._countryService).getCountry(arg_0)).map(country -> country.getName(locale)).orElse(null);
    }

    private String _getLogoURL(Organization organization) {
        return (String)Try.success((Object)organization.getLogoId()).filter(logoId -> logoId != 0L).map(logoId -> StringBundler.concat((String[])new String[]{this._portal.getPathImage(), "/organization_logo?img_id=", String.valueOf(logoId), "&t=", WebServerServletTokenUtil.getToken((long)logoId)})).orElse(null);
    }

    private PageItems<Organization> _getPageItems(Pagination pagination, Company company) {
        List organizations = this._organizationService.getOrganizations(company.getCompanyId(), 0L, pagination.getStartPosition(), pagination.getEndPosition());
        int count = this._organizationService.getOrganizationsCount(company.getCompanyId(), 0L);
        return new PageItems((Collection)organizations, count);
    }

    private String _getRegion(Organization organization) {
        return (String)Try.success((Object)organization.getRegionId()).map(arg_0 -> ((RegionService)this._regionService).getRegion(arg_0)).map(RegionModel::getName).orElse(null);
    }

    private Long _getSiteId(Organization organization) {
        return (Long)Try.success((Object)organization.getGroupId()).map(arg_0 -> ((GroupLocalService)this._groupLocalService).getGroup(arg_0)).filter(GroupModel::isSite).map(GroupModel::getGroupId).orElse(null);
    }
}

