/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.on.demand.admin.internal.ticket.generator;

import com.liferay.on.demand.admin.internal.configuration.OnDemandAdminConfiguration;
import com.liferay.on.demand.admin.internal.helper.OnDemandAdminHelper;
import com.liferay.on.demand.admin.ticket.generator.OnDemandAdminTicketGenerator;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TicketLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OnDemandAdminTicketGenerator.class})
public class OnDemandAdminTicketGeneratorImpl
implements OnDemandAdminTicketGenerator {
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private OnDemandAdminHelper _onDemandAdminHelper;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private TicketLocalService _ticketLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public Ticket generate(Company company, String justification, long requestorUserId) throws PortalException {
        return this.generate(company, justification, this._userLocalService.getUser(requestorUserId));
    }

    public Ticket generate(Company company, String justification, User requestorUser) throws PortalException {
        this._onDemandAdminHelper.checkRequestAdministratorAccessPermission(company.getCompanyId(), requestorUser.getUserId());
        User user = this._addOnDemandAdminUser(requestorUser.getUserId(), company.getCompanyId(), company.getMx(), requestorUser.getLocale(), requestorUser.getFirstName(), requestorUser.getMiddleName(), requestorUser.getLastName(), requestorUser.getMale());
        AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)"ON_DEMAND_ADMIN_TICKET_GENERATED", (String)User.class.getName(), (long)requestorUser.getUserId(), null);
        auditMessage.setAdditionalInfo(JSONUtil.put((String)"justification", (Object)justification).put("requestedCompanyId", company.getCompanyId()).put("requestedCompanyWebId", company.getWebId()));
        this._auditRouter.route(auditMessage);
        OnDemandAdminConfiguration onDemandAdminConfiguration = (OnDemandAdminConfiguration)this._configurationProvider.getSystemConfiguration(OnDemandAdminConfiguration.class);
        int expirationTime = onDemandAdminConfiguration.authenticationTokenExpirationTime();
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)company.getCompanyId());){
            Ticket ticket = this._ticketLocalService.addDistinctTicket(user.getCompanyId(), User.class.getName(), user.getUserId(), 4, justification, new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(expirationTime)), null);
            return ticket;
        }
    }

    private User _addOnDemandAdminUser(long userId, long companyId, String mx, Locale locale, String firstName, String middleName, String lastName, boolean male) throws PortalException {
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)companyId);){
            String password = PwdGenerator.getPassword((int)20);
            String screenName = this._getScreenName(userId, 0L);
            String emailAddress = screenName + "@" + mx;
            Calendar calendar = Calendar.getInstance();
            Role role = this._roleLocalService.getRole(companyId, "Administrator");
            User user = this._userLocalService.addUser(0L, companyId, false, password, password, true, null, emailAddress, locale, firstName, middleName, lastName, 0L, 0L, male, calendar.get(2), calendar.get(5), calendar.get(1), null, 1, null, null, new long[]{role.getRoleId()}, null, false, new ServiceContext());
            screenName = this._getScreenName(userId, user.getUserId());
            user.setScreenName(screenName);
            user.setEmailAddress(screenName + "@" + mx);
            user.setEmailAddressVerified(true);
            User user2 = this._userLocalService.updateUser(user);
            return user2;
        }
    }

    private String _getScreenName(long requestorUserId, long userId) throws PortalException {
        return StringBundler.concat((Object[])new Object[]{"on_demand_admin", "_", requestorUserId, "_", userId});
    }
}

