/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.on.demand.admin.internal.security.auto.login;

import com.liferay.on.demand.admin.manager.OnDemandAdminManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.TicketLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AutoLogin.class})
public class OnDemandAdminAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(OnDemandAdminAutoLogin.class);
    @Reference
    private OnDemandAdminManager _onDemandAdminManager;
    @Reference
    private TicketLocalService _ticketLocalService;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Ticket ticket = this._getTicket(httpServletRequest);
        if (ticket == null) {
            return null;
        }
        try {
            User user = this._userLocalService.getUser(ticket.getClassPK());
            if (!this._onDemandAdminManager.isOnDemandAdminUser(user)) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
            String[] stringArray = credentials;
            return stringArray;
        }
        finally {
            this._ticketLocalService.deleteTicket(ticket);
        }
    }

    private Ticket _getTicket(HttpServletRequest httpServletRequest) {
        block5: {
            String ticketKey = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"ticketKey");
            if (Validator.isNull((String)ticketKey)) {
                return null;
            }
            try {
                Ticket ticket = this._ticketLocalService.fetchTicket(ticketKey);
                if (ticket == null || ticket.getType() != 4) {
                    return null;
                }
                if (!ticket.isExpired()) {
                    return ticket;
                }
                this._ticketLocalService.deleteTicket(ticket);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
        return null;
    }
}

