/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.on.demand.admin.internal.manager;

import com.liferay.on.demand.admin.manager.OnDemandAdminManager;
import com.liferay.on.demand.admin.ticket.generator.OnDemandAdminTicketGenerator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Date;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OnDemandAdminManager.class})
public class OnDemandAdminManagerImpl
implements OnDemandAdminManager {
    @Reference
    private OnDemandAdminTicketGenerator _onDemandAdminTicketGenerator;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public void cleanUpOnDemandAdminUsers(Date olderThanDate) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._userLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property createDateProperty = PropertyFactoryUtil.forName((String)"createDate");
            dynamicQuery.add(createDateProperty.lt((Object)olderThanDate));
            Property screenNameProperty = PropertyFactoryUtil.forName((String)"screenName");
            dynamicQuery.add(screenNameProperty.like((Object)"on_demand_admin%"));
        });
        actionableDynamicQuery.setPerformActionMethod(user -> this._userLocalService.deleteUser(user));
        actionableDynamicQuery.performActions();
    }

    public String getLoginURL(Company company, PortletRequest portletRequest, long userId) throws PortalException {
        StringBundler sb = new StringBundler(4);
        boolean secure = this._portal.isSecure(this._portal.getHttpServletRequest(portletRequest));
        sb.append(this._portal.getPortalURL(company.getVirtualHostname(), this._portal.getPortalServerPort(secure), secure));
        sb.append(this._portal.getPathContext());
        sb.append("?ticketKey=");
        Ticket ticket = this._onDemandAdminTicketGenerator.generate(company, ParamUtil.getString((PortletRequest)portletRequest, (String)"justification"), userId);
        sb.append(ticket.getKey());
        return sb.toString();
    }

    public boolean isOnDemandAdminUser(User user) {
        return user != null && StringUtil.startsWith((String)user.getScreenName(), (String)"on_demand_admin");
    }
}

