/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.on.demand.admin.internal.helper;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OnDemandAdminHelper.class})
public class OnDemandAdminHelper {
    @Reference
    private UserLocalService _userLocalService;

    public void checkRequestAdministratorAccessPermission(long companyId, long userId) throws PortalException {
        if (companyId == PortalInstancePool.getDefaultCompanyId()) {
            throw new PrincipalException("Target company must not be the default company");
        }
        User user = this._userLocalService.getUser(userId);
        if (user.getCompanyId() != PortalInstancePool.getDefaultCompanyId()) {
            throw new PrincipalException("Request can only be made from the default company");
        }
        if (!PortletPermissionUtil.contains((PermissionChecker)PermissionCheckerFactoryUtil.create((User)user), (long)0L, (long)0L, (String)"com_liferay_on_demand_admin_web_internal_portlet_OnDemandAdminPortlet", (String)"REQUEST_ADMINISTRATOR_ACCESS", (boolean)true)) {
            throw new PrincipalException.MustHavePermission(userId, new String[]{"REQUEST_ADMINISTRATOR_ACCESS"});
        }
    }
}

