/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.storage.salesforce.internal.rest.manager.v1_0;

import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.dto.v1_0.Status;
import com.liferay.object.rest.dto.v1_0.util.CreatorUtil;
import com.liferay.object.rest.manager.v1_0.BaseObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.storage.salesforce.internal.http.SalesforceHttp;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.entry.manager.storage.type=salesforce"}, service={ObjectEntryManager.class})
public class SalesforceObjectEntryManagerImpl
extends BaseObjectEntryManager
implements ObjectEntryManager {
    private final Map<String, String> _defaultObjectFieldNames = HashMapBuilder.put((Object)"createDate", (Object)"CreatedDate").put((Object)"creator", (Object)"OwnerId").put((Object)"externalReferenceCode", (Object)"Id").put((Object)"id", (Object)"Id").put((Object)"modifiedDate", (Object)"LastModifiedDate").put((Object)"userName", (Object)"OwnerId").build();
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SalesforceHttp _salesforceHttp;
    @Reference
    private UserLocalService _userLocalService;

    public ObjectEntry addObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, ObjectEntry objectEntry, String scopeKey) throws Exception {
        JSONObject responseJSONObject = this._salesforceHttp.post(objectDefinition.getCompanyId(), this.getGroupId(objectDefinition, scopeKey), "sobjects/" + objectDefinition.getExternalReferenceCode(), this._toJSONObject(objectDefinition, objectEntry));
        return this.getObjectEntry(dtoConverterContext, responseJSONObject.getString("id"), objectDefinition.getCompanyId(), objectDefinition, scopeKey);
    }

    public ObjectEntry addObjectRelationshipMappingTableValues(DTOConverterContext dtoConverterContext, ObjectRelationship objectRelationship, long primaryKey1, long primaryKey2) throws Exception {
        return null;
    }

    public ObjectEntry addOrUpdateObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, ObjectEntry objectEntry, String scopeKey) throws Exception {
        this._salesforceHttp.patch(companyId, this.getGroupId(objectDefinition, scopeKey), StringBundler.concat((String[])new String[]{"sobjects/", objectDefinition.getExternalReferenceCode(), "/", externalReferenceCode}), this._toJSONObject(objectDefinition, objectEntry));
        return this.getObjectEntry(dtoConverterContext, externalReferenceCode, companyId, objectDefinition, scopeKey);
    }

    public Object addSystemObjectRelationshipMappingTableValues(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship, long primaryKey1, long primaryKey2) throws Exception {
        return null;
    }

    public void deleteObjectEntry(ObjectDefinition objectDefinition, long objectEntryId) throws Exception {
    }

    public void deleteObjectEntry(String externalReferenceCode, long companyId, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        this._salesforceHttp.delete(companyId, this.getGroupId(objectDefinition, scopeKey), StringBundler.concat((String[])new String[]{"sobjects/", objectDefinition.getExternalReferenceCode(), "/", externalReferenceCode}));
    }

    public ObjectEntry fetchObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long objectEntryId) throws Exception {
        return null;
    }

    public Page<ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, Aggregation aggregation, DTOConverterContext dtoConverterContext, Filter filter, Pagination pagination, String search, Sort[] sorts) throws Exception {
        return this._getObjectEntries(companyId, objectDefinition, scopeKey, dtoConverterContext, pagination, search, sorts);
    }

    public Page<ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, Aggregation aggregation, DTOConverterContext dtoConverterContext, Pagination pagination, Predicate predicate, String search, Sort[] sorts) throws Exception {
        return this._getObjectEntries(companyId, objectDefinition, scopeKey, dtoConverterContext, pagination, search, sorts);
    }

    public Page<ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, Aggregation aggregation, DTOConverterContext dtoConverterContext, String filterString, Pagination pagination, String search, Sort[] sorts) throws Exception {
        return null;
    }

    public ObjectEntry getObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long objectEntryId) throws Exception {
        return null;
    }

    public ObjectEntry getObjectEntry(DTOConverterContext dtoConverterContext, String externalReferenceCode, long companyId, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        return this._toObjectEntry(companyId, this._getDateFormat(), dtoConverterContext, this._salesforceHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), StringBundler.concat((String[])new String[]{"sobjects/", objectDefinition.getExternalReferenceCode(), "/", externalReferenceCode})), objectDefinition);
    }

    public Page<ObjectEntry> getObjectEntryRelatedObjectEntries(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, Long objectEntryId, String objectRelationshipName, Pagination pagination) throws Exception {
        return null;
    }

    public Page<Object> getRelatedSystemObjectEntries(ObjectDefinition objectDefinition, Long objectEntryId, String objectRelationshipName, Pagination pagination) throws Exception {
        return null;
    }

    public ObjectEntry updateObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long objectEntryId, ObjectEntry objectEntry) throws Exception {
        return null;
    }

    private DateFormat _getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    private String _getLocation(ObjectDefinition objectDefinition, Pagination pagination, String search, Sort[] sorts) {
        if (Validator.isNotNull((String)search)) {
            return HttpComponentsUtil.addParameter((String)"search", (String)"q", (String)StringBundler.concat((String[])new String[]{"FIND {", search, "} IN ALL FIELDS RETURNING ", objectDefinition.getExternalReferenceCode(), "(FIELDS(ALL)", this._getSorts(objectDefinition.getObjectDefinitionId(), sorts), this._getSalesforcePagination(pagination), ")"}));
        }
        return HttpComponentsUtil.addParameter((String)"query", (String)"q", (String)StringBundler.concat((String[])new String[]{"SELECT FIELDS(ALL) FROM ", objectDefinition.getExternalReferenceCode(), this._getSorts(objectDefinition.getObjectDefinitionId(), sorts), this._getSalesforcePagination(pagination)}));
    }

    private Page<ObjectEntry> _getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, DTOConverterContext dtoConverterContext, Pagination pagination, String search, Sort[] sorts) throws Exception {
        JSONObject responseJSONObject = this._salesforceHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), this._getLocation(objectDefinition, pagination, search, sorts));
        if (responseJSONObject == null || responseJSONObject.length() == 0) {
            return Page.of(Collections.emptyList());
        }
        JSONArray jsonArray = Validator.isNotNull((String)search) ? responseJSONObject.getJSONArray("searchRecords") : responseJSONObject.getJSONArray("records");
        return Page.of(this._toObjectEntries(companyId, dtoConverterContext, jsonArray, objectDefinition), (Pagination)pagination, (long)this._getTotalCount(companyId, objectDefinition, scopeKey, search));
    }

    private ObjectField _getObjectFieldByExternalReferenceCode(String externalReferenceCode, List<ObjectField> objectFields) {
        for (ObjectField objectField : objectFields) {
            if (!Objects.equals(externalReferenceCode, objectField.getExternalReferenceCode())) continue;
            return objectField;
        }
        return null;
    }

    private ObjectField _getObjectFieldByName(String name, List<ObjectField> objectFields) {
        for (ObjectField objectField : objectFields) {
            if (!Objects.equals(name, objectField.getName())) continue;
            return objectField;
        }
        return null;
    }

    private String _getSalesforcePagination(Pagination pagination) {
        return StringBundler.concat((Object[])new Object[]{" LIMIT ", pagination.getPageSize(), " OFFSET ", pagination.getStartPosition()});
    }

    private String _getSorts(long objectDefinitionId, Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return "";
        }
        StringBundler sb = new StringBundler();
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinitionId);
        for (Sort sort : sorts) {
            String fieldName = sort.getFieldName();
            if (fieldName.startsWith("nestedFieldArray.")) {
                String[] parts = StringUtil.split((String)sort.getFieldName(), (String)"#");
                fieldName = parts[1];
            }
            if (Objects.equals("status", fieldName)) continue;
            if (sb.length() == 0) {
                sb.append(" ORDER BY ");
            } else {
                sb.append(", ");
            }
            String defaultFieldName = this._defaultObjectFieldNames.get(fieldName);
            if (defaultFieldName != null) {
                sb.append(defaultFieldName);
            } else {
                ObjectField objectField = this._getObjectFieldByName(fieldName, objectFields);
                if (objectField == null) continue;
                sb.append(objectField.getExternalReferenceCode());
            }
            if (!sort.isReverse()) continue;
            sb.append(" DESC");
        }
        return sb.toString();
    }

    private int _getTotalCount(long companyId, ObjectDefinition objectDefinition, String scopeKey, String search) {
        if (Validator.isNotNull((String)search)) {
            JSONObject responseJSONObject = this._salesforceHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), this._getLocation(objectDefinition, Pagination.of((int)1, (int)200), search, null));
            JSONArray jsonArray = responseJSONObject.getJSONArray("searchRecords");
            return jsonArray.length();
        }
        JSONObject responseJSONObject = this._salesforceHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), HttpComponentsUtil.addParameter((String)"query", (String)"q", (String)("SELECT COUNT(Id) FROM " + objectDefinition.getExternalReferenceCode())));
        JSONArray jsonArray = responseJSONObject.getJSONArray("records");
        return jsonArray.getJSONObject(0).getInt("expr0");
    }

    private JSONObject _toJSONObject(ObjectDefinition objectDefinition, ObjectEntry objectEntry) throws Exception {
        HashMap map = new HashMap();
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId());
        Map properties = objectEntry.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            ObjectField objectField = this._getObjectFieldByName((String)entry.getKey(), objectFields);
            if (objectField == null) continue;
            Object value = entry.getValue();
            if (Objects.equals(objectField.getBusinessType(), "Picklist")) {
                HashMap valueMap = (HashMap)value;
                value = valueMap.get("key");
            }
            map.put(objectField.getExternalReferenceCode(), Objects.equals(value, "") ? null : (Object)value);
            if (!Objects.equals(objectField.getObjectFieldId(), objectDefinition.getTitleObjectFieldId())) continue;
            map.put("Name", value);
        }
        return this._jsonFactory.createJSONObject(this._jsonFactory.looseSerialize(map));
    }

    private List<ObjectEntry> _toObjectEntries(long companyId, DTOConverterContext dtoConverterContext, JSONArray jsonArray, ObjectDefinition objectDefinition) throws Exception {
        DateFormat dateFormat = this._getDateFormat();
        return JSONUtil.toList((JSONArray)jsonArray, jsonObject -> this._toObjectEntry(companyId, dateFormat, dtoConverterContext, (JSONObject)jsonObject, objectDefinition));
    }

    private ObjectEntry _toObjectEntry(final long companyId, final DateFormat dateFormat, final DTOConverterContext dtoConverterContext, final JSONObject jsonObject, ObjectDefinition objectDefinition) throws Exception {
        ObjectEntry objectEntry = new ObjectEntry(){
            {
                this.actions = HashMapBuilder.put((Object)"delete", Collections.emptyMap()).build();
                this.creator = CreatorUtil.toCreator((Portal)SalesforceObjectEntryManagerImpl.this._portal, Optional.empty(), (User)SalesforceObjectEntryManagerImpl.this._userLocalService.fetchUserByExternalReferenceCode(jsonObject.getString("OwnerId"), companyId));
                this.dateCreated = dateFormat.parse(jsonObject.getString("CreatedDate"));
                this.dateModified = dateFormat.parse(jsonObject.getString("LastModifiedDate"));
                this.externalReferenceCode = jsonObject.getString("Id");
                this.status = new Status(){
                    {
                        this.code = 0;
                        this.label = "approved";
                        this.label_i18n = "Approved";
                    }
                };
            }
        };
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId());
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ObjectField objectField = this._getObjectFieldByExternalReferenceCode(key, objectFields);
            if (objectField == null) continue;
            Map properties = objectEntry.getProperties();
            if (jsonObject.isNull(key)) {
                properties.put(objectField.getName(), null);
                continue;
            }
            Object value = jsonObject.get(key);
            if (Objects.equals(objectField.getBusinessType(), "Integer") || Objects.equals(objectField.getBusinessType(), "LongInteger")) {
                if (value instanceof BigDecimal) {
                    BigDecimal bigDecimalValue = (BigDecimal)value;
                    value = bigDecimalValue.toBigInteger();
                }
            } else if (Objects.equals(objectField.getBusinessType(), "Picklist")) {
                final ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(objectField.getListTypeDefinitionId(), (String)value);
                if (listTypeEntry == null) continue;
                value = new ListEntry(){
                    {
                        this.key = listTypeEntry.getKey();
                        this.name = listTypeEntry.getName(dtoConverterContext.getLocale());
                        this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)listTypeEntry.getNameMap());
                    }
                };
            }
            properties.put(objectField.getName(), value);
        }
        return objectEntry;
    }
}

