/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.storage.salesforce.internal.http;

import com.liferay.object.rest.manager.exception.ObjectEntryManagerHttpException;
import com.liferay.object.storage.salesforce.configuration.SalesforceConfiguration;
import com.liferay.object.storage.salesforce.internal.web.cache.SalesforceAccessTokenWebCacheItem;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.util.Http;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SalesforceHttp.class})
public class SalesforceHttp {
    @Reference
    private Http _http;
    @Reference
    private JSONFactory _jsonFactory;

    public JSONObject delete(long companyId, long groupId, String location) {
        try {
            return this._invoke(companyId, groupId, location, Http.Method.DELETE, null);
        }
        catch (Exception exception) {
            return (JSONObject)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    public JSONObject get(long companyId, long groupId, String location) {
        try {
            return this._invoke(companyId, groupId, location, Http.Method.GET, null);
        }
        catch (Exception exception) {
            return (JSONObject)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    public JSONObject patch(long companyId, long groupId, String location, JSONObject bodyJSONObject) {
        try {
            return this._invoke(companyId, groupId, location, Http.Method.PATCH, bodyJSONObject);
        }
        catch (Exception exception) {
            return (JSONObject)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    public JSONObject post(long companyId, long groupId, String location, JSONObject bodyJSONObject) {
        try {
            return this._invoke(companyId, groupId, location, Http.Method.POST, bodyJSONObject);
        }
        catch (Exception exception) {
            return (JSONObject)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    private JSONObject _getSalesforceAccessTokenJSONObject(SalesforceConfiguration salesforceConfiguration) {
        JSONObject jSONObject = SalesforceAccessTokenWebCacheItem.get(salesforceConfiguration);
        if (jSONObject == null) {
            throw new ObjectEntryManagerHttpException("Unable to authenticate with Salesforce");
        }
        return jSONObject;
    }

    private SalesforceConfiguration _getSalesforceConfiguration(long companyId, long groupId) {
        try {
            if (groupId == 0L) {
                return (SalesforceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(SalesforceConfiguration.class, (long)companyId);
            }
            return (SalesforceConfiguration)ConfigurationProviderUtil.getGroupConfiguration(SalesforceConfiguration.class, (long)groupId);
        }
        catch (ConfigurationException configurationException) {
            return (SalesforceConfiguration)ReflectionUtil.throwException((Throwable)configurationException);
        }
    }

    private JSONObject _invoke(long companyId, long groupId, String location, Http.Method method, JSONObject bodyJSONObject) throws Exception {
        byte[] bytes = this._invokeAsBytes(companyId, groupId, location, method, bodyJSONObject);
        if (bytes == null) {
            return this._jsonFactory.createJSONObject();
        }
        return this._jsonFactory.createJSONObject(new String(bytes));
    }

    private byte[] _invokeAsBytes(long companyId, long groupId, String location, Http.Method method, JSONObject bodyJSONObject) throws Exception {
        Http.Options options = new Http.Options();
        if (bodyJSONObject != null) {
            options.addHeader("Content-Type", "application/json");
        }
        JSONObject jsonObject = this._getSalesforceAccessTokenJSONObject(this._getSalesforceConfiguration(companyId, groupId));
        options.addHeader("Authorization", "Bearer " + jsonObject.getString("access_token"));
        if (bodyJSONObject != null) {
            options.setBody(bodyJSONObject.toString(), "application/json", "UTF-8");
        }
        options.setFollowRedirects(false);
        options.setLocation(StringBundler.concat((String[])new String[]{jsonObject.getString("instance_url"), "/services/data/v54.0/", location}));
        options.setMethod(method);
        byte[] bytes = this._http.URLtoByteArray(options);
        Http.Response response = options.getResponse();
        if (response.getResponseCode() < 200 || response.getResponseCode() >= 300) {
            throw new ObjectEntryManagerHttpException(StringBundler.concat((Object[])new Object[]{"Unexpected response code ", response.getResponseCode(), " with response message: ", new String(bytes)}));
        }
        return bytes;
    }
}

