/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.scripting.internal.validator;

import com.liferay.object.scripting.exception.ObjectScriptingException;
import com.liferay.object.scripting.validator.ObjectScriptingValidator;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scripting.Scripting;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.util.StringUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectScriptingValidator.class})
public class ObjectScriptingValidatorImpl
implements ObjectScriptingValidator {
    private static final int _MAXIMUM_NUMBER_OF_LINES = 2987;
    private static final String _NEW_LINE = "\n";
    private static final Log _log = LogFactoryUtil.getLog(ObjectScriptingValidatorImpl.class);
    @Reference
    private Scripting _scripting;

    public void validate(String language, String script) throws ObjectScriptingException {
        if (StringUtil.count((String)script, (String)_NEW_LINE) > 2987) {
            throw new ObjectScriptingException("The script exceeds the maximum number of lines", "the-maximum-number-of-lines-available-is-2987");
        }
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)ObjectScriptingValidatorImpl.class.getClassLoader());){
            this._scripting.validate(language, script);
        }
        catch (ScriptingException scriptingException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)scriptingException);
            }
            throw new ObjectScriptingException("The script syntax is invalid", "syntax-error");
        }
    }
}

